package zio.aws.batch.model
import zio.aws.batch.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateSchedulingPolicyRequest(
    name: String,
    fairsharePolicy: Option[zio.aws.batch.model.FairsharePolicy] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.CreateSchedulingPolicyRequest = {
    import CreateSchedulingPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.CreateSchedulingPolicyRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(fairsharePolicy.map(value => value.buildAwsValue()))(
        _.fairsharePolicy
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.CreateSchedulingPolicyRequest.ReadOnly =
    zio.aws.batch.model.CreateSchedulingPolicyRequest.wrap(buildAwsValue())
}
object CreateSchedulingPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.CreateSchedulingPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.CreateSchedulingPolicyRequest =
      zio.aws.batch.model.CreateSchedulingPolicyRequest(
        name,
        fairsharePolicy.map(value => value.asEditable),
        tags.map(value => value)
      )
    def name: String
    def fairsharePolicy: Option[zio.aws.batch.model.FairsharePolicy.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getFairsharePolicy
        : ZIO[Any, AwsError, zio.aws.batch.model.FairsharePolicy.ReadOnly] =
      AwsError.unwrapOptionField("fairsharePolicy", fairsharePolicy)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.CreateSchedulingPolicyRequest
  ) extends zio.aws.batch.model.CreateSchedulingPolicyRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val fairsharePolicy
        : Option[zio.aws.batch.model.FairsharePolicy.ReadOnly] = scala
      .Option(impl.fairsharePolicy())
      .map(value => zio.aws.batch.model.FairsharePolicy.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.batch.model.primitives
              .TagKey(key) -> zio.aws.batch.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.CreateSchedulingPolicyRequest
  ): zio.aws.batch.model.CreateSchedulingPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
