package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NetworkInterface(
    attachmentId: Option[String] = None,
    ipv6Address: Option[String] = None,
    privateIpv4Address: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.NetworkInterface = {
    import NetworkInterface.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.NetworkInterface
      .builder()
      .optionallyWith(attachmentId.map(value => value: java.lang.String))(
        _.attachmentId
      )
      .optionallyWith(ipv6Address.map(value => value: java.lang.String))(
        _.ipv6Address
      )
      .optionallyWith(privateIpv4Address.map(value => value: java.lang.String))(
        _.privateIpv4Address
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.NetworkInterface.ReadOnly =
    zio.aws.batch.model.NetworkInterface.wrap(buildAwsValue())
}
object NetworkInterface {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.NetworkInterface
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.NetworkInterface =
      zio.aws.batch.model.NetworkInterface(
        attachmentId.map(value => value),
        ipv6Address.map(value => value),
        privateIpv4Address.map(value => value)
      )
    def attachmentId: Option[String]
    def ipv6Address: Option[String]
    def privateIpv4Address: Option[String]
    def getAttachmentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attachmentId", attachmentId)
    def getIpv6Address: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6Address", ipv6Address)
    def getPrivateIpv4Address: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpv4Address", privateIpv4Address)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.NetworkInterface
  ) extends zio.aws.batch.model.NetworkInterface.ReadOnly {
    override val attachmentId: Option[String] =
      scala.Option(impl.attachmentId()).map(value => value: String)
    override val ipv6Address: Option[String] =
      scala.Option(impl.ipv6Address()).map(value => value: String)
    override val privateIpv4Address: Option[String] =
      scala.Option(impl.privateIpv4Address()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.NetworkInterface
  ): zio.aws.batch.model.NetworkInterface.ReadOnly = new Wrapper(impl)
}
