package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ComputeEnvironmentOrder(
    order: Integer,
    computeEnvironment: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ComputeEnvironmentOrder = {
    import ComputeEnvironmentOrder.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ComputeEnvironmentOrder
      .builder()
      .order(order: java.lang.Integer)
      .computeEnvironment(computeEnvironment: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ComputeEnvironmentOrder.ReadOnly =
    zio.aws.batch.model.ComputeEnvironmentOrder.wrap(buildAwsValue())
}
object ComputeEnvironmentOrder {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ComputeEnvironmentOrder
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ComputeEnvironmentOrder =
      zio.aws.batch.model.ComputeEnvironmentOrder(order, computeEnvironment)
    def order: Integer
    def computeEnvironment: String
    def getOrder: ZIO[Any, Nothing, Integer] = ZIO.succeed(order)
    def getComputeEnvironment: ZIO[Any, Nothing, String] =
      ZIO.succeed(computeEnvironment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ComputeEnvironmentOrder
  ) extends zio.aws.batch.model.ComputeEnvironmentOrder.ReadOnly {
    override val order: Integer = impl.order(): Integer
    override val computeEnvironment: String = impl.computeEnvironment(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ComputeEnvironmentOrder
  ): zio.aws.batch.model.ComputeEnvironmentOrder.ReadOnly = new Wrapper(impl)
}
