package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SubmitJobResponse(
    jobArn: Option[String] = None,
    jobName: String,
    jobId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.SubmitJobResponse = {
    import SubmitJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.SubmitJobResponse
      .builder()
      .optionallyWith(jobArn.map(value => value: java.lang.String))(_.jobArn)
      .jobName(jobName: java.lang.String)
      .jobId(jobId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.SubmitJobResponse.ReadOnly =
    zio.aws.batch.model.SubmitJobResponse.wrap(buildAwsValue())
}
object SubmitJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.SubmitJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.SubmitJobResponse = zio.aws.batch.model
      .SubmitJobResponse(jobArn.map(value => value), jobName, jobId)
    def jobArn: Option[String]
    def jobName: String
    def jobId: String
    def getJobArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getJobName: ZIO[Any, Nothing, String] = ZIO.succeed(jobName)
    def getJobId: ZIO[Any, Nothing, String] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.SubmitJobResponse
  ) extends zio.aws.batch.model.SubmitJobResponse.ReadOnly {
    override val jobArn: Option[String] =
      scala.Option(impl.jobArn()).map(value => value: String)
    override val jobName: String = impl.jobName(): String
    override val jobId: String = impl.jobId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.SubmitJobResponse
  ): zio.aws.batch.model.SubmitJobResponse.ReadOnly = new Wrapper(impl)
}
