package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeJobDefinitionsRequest(
    jobDefinitions: Option[Iterable[String]] = None,
    maxResults: Option[Integer] = None,
    jobDefinitionName: Option[String] = None,
    status: Option[String] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.DescribeJobDefinitionsRequest = {
    import DescribeJobDefinitionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.DescribeJobDefinitionsRequest
      .builder()
      .optionallyWith(
        jobDefinitions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.jobDefinitions)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(jobDefinitionName.map(value => value: java.lang.String))(
        _.jobDefinitionName
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.DescribeJobDefinitionsRequest.ReadOnly =
    zio.aws.batch.model.DescribeJobDefinitionsRequest.wrap(buildAwsValue())
}
object DescribeJobDefinitionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.DescribeJobDefinitionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.DescribeJobDefinitionsRequest =
      zio.aws.batch.model.DescribeJobDefinitionsRequest(
        jobDefinitions.map(value => value),
        maxResults.map(value => value),
        jobDefinitionName.map(value => value),
        status.map(value => value),
        nextToken.map(value => value)
      )
    def jobDefinitions: Option[List[String]]
    def maxResults: Option[Integer]
    def jobDefinitionName: Option[String]
    def status: Option[String]
    def nextToken: Option[String]
    def getJobDefinitions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("jobDefinitions", jobDefinitions)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getJobDefinitionName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jobDefinitionName", jobDefinitionName)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.DescribeJobDefinitionsRequest
  ) extends zio.aws.batch.model.DescribeJobDefinitionsRequest.ReadOnly {
    override val jobDefinitions: Option[List[String]] = scala
      .Option(impl.jobDefinitions())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val maxResults: Option[Integer] =
      scala.Option(impl.maxResults()).map(value => value: Integer)
    override val jobDefinitionName: Option[String] =
      scala.Option(impl.jobDefinitionName()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.DescribeJobDefinitionsRequest
  ): zio.aws.batch.model.DescribeJobDefinitionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
