package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ContainerProperties(
    image: Option[String] = None,
    vcpus: Option[Integer] = None,
    memory: Option[Integer] = None,
    command: Option[Iterable[String]] = None,
    jobRoleArn: Option[String] = None,
    executionRoleArn: Option[String] = None,
    volumes: Option[Iterable[zio.aws.batch.model.Volume]] = None,
    environment: Option[Iterable[zio.aws.batch.model.KeyValuePair]] = None,
    mountPoints: Option[Iterable[zio.aws.batch.model.MountPoint]] = None,
    readonlyRootFilesystem: Option[Boolean] = None,
    privileged: Option[Boolean] = None,
    ulimits: Option[Iterable[zio.aws.batch.model.Ulimit]] = None,
    user: Option[String] = None,
    instanceType: Option[String] = None,
    resourceRequirements: Option[
      Iterable[zio.aws.batch.model.ResourceRequirement]
    ] = None,
    linuxParameters: Option[zio.aws.batch.model.LinuxParameters] = None,
    logConfiguration: Option[zio.aws.batch.model.LogConfiguration] = None,
    secrets: Option[Iterable[zio.aws.batch.model.Secret]] = None,
    networkConfiguration: Option[zio.aws.batch.model.NetworkConfiguration] =
      None,
    fargatePlatformConfiguration: Option[
      zio.aws.batch.model.FargatePlatformConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ContainerProperties = {
    import ContainerProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ContainerProperties
      .builder()
      .optionallyWith(image.map(value => value: java.lang.String))(_.image)
      .optionallyWith(
        vcpus.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.vcpus)
      .optionallyWith(
        memory.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.memory)
      .optionallyWith(
        command.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.command)
      .optionallyWith(jobRoleArn.map(value => value: java.lang.String))(
        _.jobRoleArn
      )
      .optionallyWith(executionRoleArn.map(value => value: java.lang.String))(
        _.executionRoleArn
      )
      .optionallyWith(
        volumes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumes)
      .optionallyWith(
        environment.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environment)
      .optionallyWith(
        mountPoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mountPoints)
      .optionallyWith(
        readonlyRootFilesystem.map(value => value: java.lang.Boolean)
      )(_.readonlyRootFilesystem)
      .optionallyWith(privileged.map(value => value: java.lang.Boolean))(
        _.privileged
      )
      .optionallyWith(
        ulimits.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ulimits)
      .optionallyWith(user.map(value => value: java.lang.String))(_.user)
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(
        resourceRequirements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceRequirements)
      .optionallyWith(linuxParameters.map(value => value.buildAwsValue()))(
        _.linuxParameters
      )
      .optionallyWith(logConfiguration.map(value => value.buildAwsValue()))(
        _.logConfiguration
      )
      .optionallyWith(
        secrets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secrets)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(
        fargatePlatformConfiguration.map(value => value.buildAwsValue())
      )(_.fargatePlatformConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ContainerProperties.ReadOnly =
    zio.aws.batch.model.ContainerProperties.wrap(buildAwsValue())
}
object ContainerProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ContainerProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ContainerProperties =
      zio.aws.batch.model.ContainerProperties(
        image.map(value => value),
        vcpus.map(value => value),
        memory.map(value => value),
        command.map(value => value),
        jobRoleArn.map(value => value),
        executionRoleArn.map(value => value),
        volumes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        environment.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        mountPoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        readonlyRootFilesystem.map(value => value),
        privileged.map(value => value),
        ulimits.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        user.map(value => value),
        instanceType.map(value => value),
        resourceRequirements.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        linuxParameters.map(value => value.asEditable),
        logConfiguration.map(value => value.asEditable),
        secrets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkConfiguration.map(value => value.asEditable),
        fargatePlatformConfiguration.map(value => value.asEditable)
      )
    def image: Option[String]
    def vcpus: Option[Integer]
    def memory: Option[Integer]
    def command: Option[List[String]]
    def jobRoleArn: Option[String]
    def executionRoleArn: Option[String]
    def volumes: Option[List[zio.aws.batch.model.Volume.ReadOnly]]
    def environment: Option[List[zio.aws.batch.model.KeyValuePair.ReadOnly]]
    def mountPoints: Option[List[zio.aws.batch.model.MountPoint.ReadOnly]]
    def readonlyRootFilesystem: Option[Boolean]
    def privileged: Option[Boolean]
    def ulimits: Option[List[zio.aws.batch.model.Ulimit.ReadOnly]]
    def user: Option[String]
    def instanceType: Option[String]
    def resourceRequirements
        : Option[List[zio.aws.batch.model.ResourceRequirement.ReadOnly]]
    def linuxParameters: Option[zio.aws.batch.model.LinuxParameters.ReadOnly]
    def logConfiguration: Option[zio.aws.batch.model.LogConfiguration.ReadOnly]
    def secrets: Option[List[zio.aws.batch.model.Secret.ReadOnly]]
    def networkConfiguration
        : Option[zio.aws.batch.model.NetworkConfiguration.ReadOnly]
    def fargatePlatformConfiguration
        : Option[zio.aws.batch.model.FargatePlatformConfiguration.ReadOnly]
    def getImage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("image", image)
    def getVcpus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("vcpus", vcpus)
    def getMemory: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("memory", memory)
    def getCommand: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("command", command)
    def getJobRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jobRoleArn", jobRoleArn)
    def getExecutionRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
    def getVolumes
        : ZIO[Any, AwsError, List[zio.aws.batch.model.Volume.ReadOnly]] =
      AwsError.unwrapOptionField("volumes", volumes)
    def getEnvironment
        : ZIO[Any, AwsError, List[zio.aws.batch.model.KeyValuePair.ReadOnly]] =
      AwsError.unwrapOptionField("environment", environment)
    def getMountPoints
        : ZIO[Any, AwsError, List[zio.aws.batch.model.MountPoint.ReadOnly]] =
      AwsError.unwrapOptionField("mountPoints", mountPoints)
    def getReadonlyRootFilesystem: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("readonlyRootFilesystem", readonlyRootFilesystem)
    def getPrivileged: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("privileged", privileged)
    def getUlimits
        : ZIO[Any, AwsError, List[zio.aws.batch.model.Ulimit.ReadOnly]] =
      AwsError.unwrapOptionField("ulimits", ulimits)
    def getUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("user", user)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getResourceRequirements: ZIO[Any, AwsError, List[
      zio.aws.batch.model.ResourceRequirement.ReadOnly
    ]] =
      AwsError.unwrapOptionField("resourceRequirements", resourceRequirements)
    def getLinuxParameters
        : ZIO[Any, AwsError, zio.aws.batch.model.LinuxParameters.ReadOnly] =
      AwsError.unwrapOptionField("linuxParameters", linuxParameters)
    def getLogConfiguration
        : ZIO[Any, AwsError, zio.aws.batch.model.LogConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("logConfiguration", logConfiguration)
    def getSecrets
        : ZIO[Any, AwsError, List[zio.aws.batch.model.Secret.ReadOnly]] =
      AwsError.unwrapOptionField("secrets", secrets)
    def getNetworkConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.batch.model.NetworkConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getFargatePlatformConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.batch.model.FargatePlatformConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "fargatePlatformConfiguration",
      fargatePlatformConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ContainerProperties
  ) extends zio.aws.batch.model.ContainerProperties.ReadOnly {
    override val image: Option[String] =
      scala.Option(impl.image()).map(value => value: String)
    override val vcpus: Option[Integer] = scala
      .Option(impl.vcpus())
      .map(value => zio.aws.batch.model.primitives.Integer(value))
    override val memory: Option[Integer] = scala
      .Option(impl.memory())
      .map(value => zio.aws.batch.model.primitives.Integer(value))
    override val command: Option[List[String]] = scala
      .Option(impl.command())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val jobRoleArn: Option[String] =
      scala.Option(impl.jobRoleArn()).map(value => value: String)
    override val executionRoleArn: Option[String] =
      scala.Option(impl.executionRoleArn()).map(value => value: String)
    override val volumes: Option[List[zio.aws.batch.model.Volume.ReadOnly]] =
      scala
        .Option(impl.volumes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.Volume.wrap(item)
          }.toList
        )
    override val environment
        : Option[List[zio.aws.batch.model.KeyValuePair.ReadOnly]] = scala
      .Option(impl.environment())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.batch.model.KeyValuePair.wrap(item)
        }.toList
      )
    override val mountPoints
        : Option[List[zio.aws.batch.model.MountPoint.ReadOnly]] = scala
      .Option(impl.mountPoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.batch.model.MountPoint.wrap(item)
        }.toList
      )
    override val readonlyRootFilesystem: Option[Boolean] =
      scala.Option(impl.readonlyRootFilesystem()).map(value => value: Boolean)
    override val privileged: Option[Boolean] =
      scala.Option(impl.privileged()).map(value => value: Boolean)
    override val ulimits: Option[List[zio.aws.batch.model.Ulimit.ReadOnly]] =
      scala
        .Option(impl.ulimits())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.Ulimit.wrap(item)
          }.toList
        )
    override val user: Option[String] =
      scala.Option(impl.user()).map(value => value: String)
    override val instanceType: Option[String] =
      scala.Option(impl.instanceType()).map(value => value: String)
    override val resourceRequirements
        : Option[List[zio.aws.batch.model.ResourceRequirement.ReadOnly]] = scala
      .Option(impl.resourceRequirements())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.batch.model.ResourceRequirement.wrap(item)
        }.toList
      )
    override val linuxParameters
        : Option[zio.aws.batch.model.LinuxParameters.ReadOnly] = scala
      .Option(impl.linuxParameters())
      .map(value => zio.aws.batch.model.LinuxParameters.wrap(value))
    override val logConfiguration
        : Option[zio.aws.batch.model.LogConfiguration.ReadOnly] = scala
      .Option(impl.logConfiguration())
      .map(value => zio.aws.batch.model.LogConfiguration.wrap(value))
    override val secrets: Option[List[zio.aws.batch.model.Secret.ReadOnly]] =
      scala
        .Option(impl.secrets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.Secret.wrap(item)
          }.toList
        )
    override val networkConfiguration
        : Option[zio.aws.batch.model.NetworkConfiguration.ReadOnly] = scala
      .Option(impl.networkConfiguration())
      .map(value => zio.aws.batch.model.NetworkConfiguration.wrap(value))
    override val fargatePlatformConfiguration
        : Option[zio.aws.batch.model.FargatePlatformConfiguration.ReadOnly] =
      scala
        .Option(impl.fargatePlatformConfiguration())
        .map(value =>
          zio.aws.batch.model.FargatePlatformConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ContainerProperties
  ): zio.aws.batch.model.ContainerProperties.ReadOnly = new Wrapper(impl)
}
