package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Ulimit(hardLimit: Integer, name: String, softLimit: Integer) {
  def buildAwsValue(): software.amazon.awssdk.services.batch.model.Ulimit = {
    import Ulimit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.Ulimit
      .builder()
      .hardLimit(Integer.unwrap(hardLimit): java.lang.Integer)
      .name(name: java.lang.String)
      .softLimit(Integer.unwrap(softLimit): java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.Ulimit.ReadOnly =
    zio.aws.batch.model.Ulimit.wrap(buildAwsValue())
}
object Ulimit {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.batch.model.Ulimit] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.Ulimit =
      zio.aws.batch.model.Ulimit(hardLimit, name, softLimit)
    def hardLimit: Integer
    def name: String
    def softLimit: Integer
    def getHardLimit: ZIO[Any, Nothing, Integer] = ZIO.succeed(hardLimit)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getSoftLimit: ZIO[Any, Nothing, Integer] = ZIO.succeed(softLimit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.Ulimit
  ) extends zio.aws.batch.model.Ulimit.ReadOnly {
    override val hardLimit: Integer =
      zio.aws.batch.model.primitives.Integer(impl.hardLimit())
    override val name: String = impl.name(): String
    override val softLimit: Integer =
      zio.aws.batch.model.primitives.Integer(impl.softLimit())
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.Ulimit
  ): zio.aws.batch.model.Ulimit.ReadOnly = new Wrapper(impl)
}
