package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeJobDefinitionsResponse(
    jobDefinitions: Option[Iterable[zio.aws.batch.model.JobDefinition]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.DescribeJobDefinitionsResponse = {
    import DescribeJobDefinitionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.DescribeJobDefinitionsResponse
      .builder()
      .optionallyWith(
        jobDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobDefinitions)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.DescribeJobDefinitionsResponse.ReadOnly =
    zio.aws.batch.model.DescribeJobDefinitionsResponse.wrap(buildAwsValue())
}
object DescribeJobDefinitionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.DescribeJobDefinitionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.DescribeJobDefinitionsResponse =
      zio.aws.batch.model.DescribeJobDefinitionsResponse(
        jobDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def jobDefinitions: Option[List[zio.aws.batch.model.JobDefinition.ReadOnly]]
    def nextToken: Option[String]
    def getJobDefinitions
        : ZIO[Any, AwsError, List[zio.aws.batch.model.JobDefinition.ReadOnly]] =
      AwsError.unwrapOptionField("jobDefinitions", jobDefinitions)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.DescribeJobDefinitionsResponse
  ) extends zio.aws.batch.model.DescribeJobDefinitionsResponse.ReadOnly {
    override val jobDefinitions
        : Option[List[zio.aws.batch.model.JobDefinition.ReadOnly]] = scala
      .Option(impl.jobDefinitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.batch.model.JobDefinition.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.DescribeJobDefinitionsResponse
  ): zio.aws.batch.model.DescribeJobDefinitionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
