package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateJobQueueRequest(
    jobQueue: String,
    state: Option[zio.aws.batch.model.JQState] = None,
    schedulingPolicyArn: Option[String] = None,
    priority: Option[Integer] = None,
    computeEnvironmentOrder: Option[
      Iterable[zio.aws.batch.model.ComputeEnvironmentOrder]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.UpdateJobQueueRequest = {
    import UpdateJobQueueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.UpdateJobQueueRequest
      .builder()
      .jobQueue(jobQueue: java.lang.String)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        schedulingPolicyArn.map(value => value: java.lang.String)
      )(_.schedulingPolicyArn)
      .optionallyWith(
        priority.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.priority)
      .optionallyWith(
        computeEnvironmentOrder.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.computeEnvironmentOrder)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.UpdateJobQueueRequest.ReadOnly =
    zio.aws.batch.model.UpdateJobQueueRequest.wrap(buildAwsValue())
}
object UpdateJobQueueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.UpdateJobQueueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.UpdateJobQueueRequest =
      zio.aws.batch.model.UpdateJobQueueRequest(
        jobQueue,
        state.map(value => value),
        schedulingPolicyArn.map(value => value),
        priority.map(value => value),
        computeEnvironmentOrder.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobQueue: String
    def state: Option[zio.aws.batch.model.JQState]
    def schedulingPolicyArn: Option[String]
    def priority: Option[Integer]
    def computeEnvironmentOrder
        : Option[List[zio.aws.batch.model.ComputeEnvironmentOrder.ReadOnly]]
    def getJobQueue: ZIO[Any, Nothing, String] = ZIO.succeed(jobQueue)
    def getState: ZIO[Any, AwsError, zio.aws.batch.model.JQState] =
      AwsError.unwrapOptionField("state", state)
    def getSchedulingPolicyArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schedulingPolicyArn", schedulingPolicyArn)
    def getPriority: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("priority", priority)
    def getComputeEnvironmentOrder: ZIO[Any, AwsError, List[
      zio.aws.batch.model.ComputeEnvironmentOrder.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "computeEnvironmentOrder",
      computeEnvironmentOrder
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.UpdateJobQueueRequest
  ) extends zio.aws.batch.model.UpdateJobQueueRequest.ReadOnly {
    override val jobQueue: String = impl.jobQueue(): String
    override val state: Option[zio.aws.batch.model.JQState] = scala
      .Option(impl.state())
      .map(value => zio.aws.batch.model.JQState.wrap(value))
    override val schedulingPolicyArn: Option[String] =
      scala.Option(impl.schedulingPolicyArn()).map(value => value: String)
    override val priority: Option[Integer] = scala
      .Option(impl.priority())
      .map(value => zio.aws.batch.model.primitives.Integer(value))
    override val computeEnvironmentOrder
        : Option[List[zio.aws.batch.model.ComputeEnvironmentOrder.ReadOnly]] =
      scala
        .Option(impl.computeEnvironmentOrder())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.ComputeEnvironmentOrder.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.UpdateJobQueueRequest
  ): zio.aws.batch.model.UpdateJobQueueRequest.ReadOnly = new Wrapper(impl)
}
