package zio.aws.batch.model
import zio.aws.batch.model.primitives.{TagValue, TagKey, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class JobDefinition(
    jobDefinitionName: String,
    jobDefinitionArn: String,
    revision: Integer,
    status: Option[String] = None,
    `type`: String,
    schedulingPriority: Option[Integer] = None,
    parameters: Option[Map[String, String]] = None,
    retryStrategy: Option[zio.aws.batch.model.RetryStrategy] = None,
    containerProperties: Option[zio.aws.batch.model.ContainerProperties] = None,
    timeout: Option[zio.aws.batch.model.JobTimeout] = None,
    nodeProperties: Option[zio.aws.batch.model.NodeProperties] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    propagateTags: Option[Boolean] = None,
    platformCapabilities: Option[
      Iterable[zio.aws.batch.model.PlatformCapability]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.JobDefinition = {
    import JobDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.JobDefinition
      .builder()
      .jobDefinitionName(jobDefinitionName: java.lang.String)
      .jobDefinitionArn(jobDefinitionArn: java.lang.String)
      .revision(Integer.unwrap(revision): java.lang.Integer)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .`type`(`type`: java.lang.String)
      .optionallyWith(
        schedulingPriority.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.schedulingPriority)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(retryStrategy.map(value => value.buildAwsValue()))(
        _.retryStrategy
      )
      .optionallyWith(containerProperties.map(value => value.buildAwsValue()))(
        _.containerProperties
      )
      .optionallyWith(timeout.map(value => value.buildAwsValue()))(_.timeout)
      .optionallyWith(nodeProperties.map(value => value.buildAwsValue()))(
        _.nodeProperties
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(propagateTags.map(value => value: java.lang.Boolean))(
        _.propagateTags
      )
      .optionallyWith(
        platformCapabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.platformCapabilitiesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.JobDefinition.ReadOnly =
    zio.aws.batch.model.JobDefinition.wrap(buildAwsValue())
}
object JobDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.JobDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.JobDefinition =
      zio.aws.batch.model.JobDefinition(
        jobDefinitionName,
        jobDefinitionArn,
        revision,
        status.map(value => value),
        `type`,
        schedulingPriority.map(value => value),
        parameters.map(value => value),
        retryStrategy.map(value => value.asEditable),
        containerProperties.map(value => value.asEditable),
        timeout.map(value => value.asEditable),
        nodeProperties.map(value => value.asEditable),
        tags.map(value => value),
        propagateTags.map(value => value),
        platformCapabilities.map(value => value)
      )
    def jobDefinitionName: String
    def jobDefinitionArn: String
    def revision: Integer
    def status: Option[String]
    def `type`: String
    def schedulingPriority: Option[Integer]
    def parameters: Option[Map[String, String]]
    def retryStrategy: Option[zio.aws.batch.model.RetryStrategy.ReadOnly]
    def containerProperties
        : Option[zio.aws.batch.model.ContainerProperties.ReadOnly]
    def timeout: Option[zio.aws.batch.model.JobTimeout.ReadOnly]
    def nodeProperties: Option[zio.aws.batch.model.NodeProperties.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def propagateTags: Option[Boolean]
    def platformCapabilities
        : Option[List[zio.aws.batch.model.PlatformCapability]]
    def getJobDefinitionName: ZIO[Any, Nothing, String] =
      ZIO.succeed(jobDefinitionName)
    def getJobDefinitionArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(jobDefinitionArn)
    def getRevision: ZIO[Any, Nothing, Integer] = ZIO.succeed(revision)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getType: ZIO[Any, Nothing, String] = ZIO.succeed(`type`)
    def getSchedulingPriority: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("schedulingPriority", schedulingPriority)
    def getParameters: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getRetryStrategy
        : ZIO[Any, AwsError, zio.aws.batch.model.RetryStrategy.ReadOnly] =
      AwsError.unwrapOptionField("retryStrategy", retryStrategy)
    def getContainerProperties
        : ZIO[Any, AwsError, zio.aws.batch.model.ContainerProperties.ReadOnly] =
      AwsError.unwrapOptionField("containerProperties", containerProperties)
    def getTimeout
        : ZIO[Any, AwsError, zio.aws.batch.model.JobTimeout.ReadOnly] =
      AwsError.unwrapOptionField("timeout", timeout)
    def getNodeProperties
        : ZIO[Any, AwsError, zio.aws.batch.model.NodeProperties.ReadOnly] =
      AwsError.unwrapOptionField("nodeProperties", nodeProperties)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPropagateTags: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("propagateTags", propagateTags)
    def getPlatformCapabilities
        : ZIO[Any, AwsError, List[zio.aws.batch.model.PlatformCapability]] =
      AwsError.unwrapOptionField("platformCapabilities", platformCapabilities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.JobDefinition
  ) extends zio.aws.batch.model.JobDefinition.ReadOnly {
    override val jobDefinitionName: String = impl.jobDefinitionName(): String
    override val jobDefinitionArn: String = impl.jobDefinitionArn(): String
    override val revision: Integer =
      zio.aws.batch.model.primitives.Integer(impl.revision())
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val `type`: String = impl.`type`(): String
    override val schedulingPriority: Option[Integer] = scala
      .Option(impl.schedulingPriority())
      .map(value => zio.aws.batch.model.primitives.Integer(value))
    override val parameters: Option[Map[String, String]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val retryStrategy
        : Option[zio.aws.batch.model.RetryStrategy.ReadOnly] = scala
      .Option(impl.retryStrategy())
      .map(value => zio.aws.batch.model.RetryStrategy.wrap(value))
    override val containerProperties
        : Option[zio.aws.batch.model.ContainerProperties.ReadOnly] = scala
      .Option(impl.containerProperties())
      .map(value => zio.aws.batch.model.ContainerProperties.wrap(value))
    override val timeout: Option[zio.aws.batch.model.JobTimeout.ReadOnly] =
      scala
        .Option(impl.timeout())
        .map(value => zio.aws.batch.model.JobTimeout.wrap(value))
    override val nodeProperties
        : Option[zio.aws.batch.model.NodeProperties.ReadOnly] = scala
      .Option(impl.nodeProperties())
      .map(value => zio.aws.batch.model.NodeProperties.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.batch.model.primitives
              .TagKey(key) -> zio.aws.batch.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val propagateTags: Option[Boolean] =
      scala.Option(impl.propagateTags()).map(value => value: Boolean)
    override val platformCapabilities
        : Option[List[zio.aws.batch.model.PlatformCapability]] = scala
      .Option(impl.platformCapabilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.batch.model.PlatformCapability.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.JobDefinition
  ): zio.aws.batch.model.JobDefinition.ReadOnly = new Wrapper(impl)
}
