package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ArrayPropertiesDetail(
    statusSummary: Option[Map[String, Integer]] = None,
    size: Option[Integer] = None,
    index: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ArrayPropertiesDetail = {
    import ArrayPropertiesDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ArrayPropertiesDetail
      .builder()
      .optionallyWith(
        statusSummary.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (Integer.unwrap(
                value
              ): java.lang.Integer)
            })
            .asJava
        )
      )(_.statusSummary)
      .optionallyWith(
        size.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.size)
      .optionallyWith(
        index.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.index)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ArrayPropertiesDetail.ReadOnly =
    zio.aws.batch.model.ArrayPropertiesDetail.wrap(buildAwsValue())
}
object ArrayPropertiesDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ArrayPropertiesDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ArrayPropertiesDetail =
      zio.aws.batch.model.ArrayPropertiesDetail(
        statusSummary.map(value => value),
        size.map(value => value),
        index.map(value => value)
      )
    def statusSummary: Option[Map[String, Integer]]
    def size: Option[Integer]
    def index: Option[Integer]
    def getStatusSummary: ZIO[Any, AwsError, Map[String, Integer]] =
      AwsError.unwrapOptionField("statusSummary", statusSummary)
    def getSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("size", size)
    def getIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("index", index)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ArrayPropertiesDetail
  ) extends zio.aws.batch.model.ArrayPropertiesDetail.ReadOnly {
    override val statusSummary: Option[Map[String, Integer]] = scala
      .Option(impl.statusSummary())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.batch.model.primitives.Integer(value)
          })
          .toMap
      )
    override val size: Option[Integer] = scala
      .Option(impl.size())
      .map(value => zio.aws.batch.model.primitives.Integer(value))
    override val index: Option[Integer] = scala
      .Option(impl.index())
      .map(value => zio.aws.batch.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ArrayPropertiesDetail
  ): zio.aws.batch.model.ArrayPropertiesDetail.ReadOnly = new Wrapper(impl)
}
