package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TerminateJobRequest(jobId: String, reason: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.TerminateJobRequest = {
    import TerminateJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.TerminateJobRequest
      .builder()
      .jobId(jobId: java.lang.String)
      .reason(reason: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.TerminateJobRequest.ReadOnly =
    zio.aws.batch.model.TerminateJobRequest.wrap(buildAwsValue())
}
object TerminateJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.TerminateJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.TerminateJobRequest =
      zio.aws.batch.model.TerminateJobRequest(jobId, reason)
    def jobId: String
    def reason: String
    def getJobId: ZIO[Any, Nothing, String] = ZIO.succeed(jobId)
    def getReason: ZIO[Any, Nothing, String] = ZIO.succeed(reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.TerminateJobRequest
  ) extends zio.aws.batch.model.TerminateJobRequest.ReadOnly {
    override val jobId: String = impl.jobId(): String
    override val reason: String = impl.reason(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.TerminateJobRequest
  ): zio.aws.batch.model.TerminateJobRequest.ReadOnly = new Wrapper(impl)
}
