package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FairsharePolicy(
    shareDecaySeconds: Option[Integer] = None,
    computeReservation: Option[Integer] = None,
    shareDistribution: Option[Iterable[zio.aws.batch.model.ShareAttributes]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.FairsharePolicy = {
    import FairsharePolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.FairsharePolicy
      .builder()
      .optionallyWith(
        shareDecaySeconds.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.shareDecaySeconds)
      .optionallyWith(
        computeReservation.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.computeReservation)
      .optionallyWith(
        shareDistribution.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.shareDistribution)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.FairsharePolicy.ReadOnly =
    zio.aws.batch.model.FairsharePolicy.wrap(buildAwsValue())
}
object FairsharePolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.FairsharePolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.FairsharePolicy =
      zio.aws.batch.model.FairsharePolicy(
        shareDecaySeconds.map(value => value),
        computeReservation.map(value => value),
        shareDistribution.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def shareDecaySeconds: Option[Integer]
    def computeReservation: Option[Integer]
    def shareDistribution
        : Option[List[zio.aws.batch.model.ShareAttributes.ReadOnly]]
    def getShareDecaySeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("shareDecaySeconds", shareDecaySeconds)
    def getComputeReservation: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("computeReservation", computeReservation)
    def getShareDistribution: ZIO[Any, AwsError, List[
      zio.aws.batch.model.ShareAttributes.ReadOnly
    ]] = AwsError.unwrapOptionField("shareDistribution", shareDistribution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.FairsharePolicy
  ) extends zio.aws.batch.model.FairsharePolicy.ReadOnly {
    override val shareDecaySeconds: Option[Integer] = scala
      .Option(impl.shareDecaySeconds())
      .map(value => zio.aws.batch.model.primitives.Integer(value))
    override val computeReservation: Option[Integer] = scala
      .Option(impl.computeReservation())
      .map(value => zio.aws.batch.model.primitives.Integer(value))
    override val shareDistribution
        : Option[List[zio.aws.batch.model.ShareAttributes.ReadOnly]] = scala
      .Option(impl.shareDistribution())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.batch.model.ShareAttributes.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.FairsharePolicy
  ): zio.aws.batch.model.FairsharePolicy.ReadOnly = new Wrapper(impl)
}
