package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ArrayPropertiesSummary(
    size: Option[Integer] = None,
    index: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ArrayPropertiesSummary = {
    import ArrayPropertiesSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ArrayPropertiesSummary
      .builder()
      .optionallyWith(
        size.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.size)
      .optionallyWith(
        index.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.index)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ArrayPropertiesSummary.ReadOnly =
    zio.aws.batch.model.ArrayPropertiesSummary.wrap(buildAwsValue())
}
object ArrayPropertiesSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ArrayPropertiesSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ArrayPropertiesSummary =
      zio.aws.batch.model.ArrayPropertiesSummary(
        size.map(value => value),
        index.map(value => value)
      )
    def size: Option[Integer]
    def index: Option[Integer]
    def getSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("size", size)
    def getIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("index", index)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ArrayPropertiesSummary
  ) extends zio.aws.batch.model.ArrayPropertiesSummary.ReadOnly {
    override val size: Option[Integer] = scala
      .Option(impl.size())
      .map(value => zio.aws.batch.model.primitives.Integer(value))
    override val index: Option[Integer] = scala
      .Option(impl.index())
      .map(value => zio.aws.batch.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ArrayPropertiesSummary
  ): zio.aws.batch.model.ArrayPropertiesSummary.ReadOnly = new Wrapper(impl)
}
