package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LinuxParameters(
    devices: Option[Iterable[zio.aws.batch.model.Device]] = None,
    initProcessEnabled: Option[Boolean] = None,
    sharedMemorySize: Option[Integer] = None,
    tmpfs: Option[Iterable[zio.aws.batch.model.Tmpfs]] = None,
    maxSwap: Option[Integer] = None,
    swappiness: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.LinuxParameters = {
    import LinuxParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.LinuxParameters
      .builder()
      .optionallyWith(
        devices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.devices)
      .optionallyWith(
        initProcessEnabled.map(value => value: java.lang.Boolean)
      )(_.initProcessEnabled)
      .optionallyWith(
        sharedMemorySize.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.sharedMemorySize)
      .optionallyWith(
        tmpfs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tmpfs)
      .optionallyWith(
        maxSwap.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxSwap)
      .optionallyWith(
        swappiness.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.swappiness)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.LinuxParameters.ReadOnly =
    zio.aws.batch.model.LinuxParameters.wrap(buildAwsValue())
}
object LinuxParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.LinuxParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.LinuxParameters =
      zio.aws.batch.model.LinuxParameters(
        devices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        initProcessEnabled.map(value => value),
        sharedMemorySize.map(value => value),
        tmpfs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxSwap.map(value => value),
        swappiness.map(value => value)
      )
    def devices: Option[List[zio.aws.batch.model.Device.ReadOnly]]
    def initProcessEnabled: Option[Boolean]
    def sharedMemorySize: Option[Integer]
    def tmpfs: Option[List[zio.aws.batch.model.Tmpfs.ReadOnly]]
    def maxSwap: Option[Integer]
    def swappiness: Option[Integer]
    def getDevices
        : ZIO[Any, AwsError, List[zio.aws.batch.model.Device.ReadOnly]] =
      AwsError.unwrapOptionField("devices", devices)
    def getInitProcessEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("initProcessEnabled", initProcessEnabled)
    def getSharedMemorySize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sharedMemorySize", sharedMemorySize)
    def getTmpfs: ZIO[Any, AwsError, List[zio.aws.batch.model.Tmpfs.ReadOnly]] =
      AwsError.unwrapOptionField("tmpfs", tmpfs)
    def getMaxSwap: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxSwap", maxSwap)
    def getSwappiness: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("swappiness", swappiness)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.LinuxParameters
  ) extends zio.aws.batch.model.LinuxParameters.ReadOnly {
    override val devices: Option[List[zio.aws.batch.model.Device.ReadOnly]] =
      scala
        .Option(impl.devices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.Device.wrap(item)
          }.toList
        )
    override val initProcessEnabled: Option[Boolean] =
      scala.Option(impl.initProcessEnabled()).map(value => value: Boolean)
    override val sharedMemorySize: Option[Integer] = scala
      .Option(impl.sharedMemorySize())
      .map(value => zio.aws.batch.model.primitives.Integer(value))
    override val tmpfs: Option[List[zio.aws.batch.model.Tmpfs.ReadOnly]] = scala
      .Option(impl.tmpfs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.batch.model.Tmpfs.wrap(item)
        }.toList
      )
    override val maxSwap: Option[Integer] = scala
      .Option(impl.maxSwap())
      .map(value => zio.aws.batch.model.primitives.Integer(value))
    override val swappiness: Option[Integer] = scala
      .Option(impl.swappiness())
      .map(value => zio.aws.batch.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.LinuxParameters
  ): zio.aws.batch.model.LinuxParameters.ReadOnly = new Wrapper(impl)
}
