package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NodePropertiesSummary(
    isMainNode: Option[Boolean] = None,
    numNodes: Option[Integer] = None,
    nodeIndex: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.NodePropertiesSummary = {
    import NodePropertiesSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.NodePropertiesSummary
      .builder()
      .optionallyWith(isMainNode.map(value => value: java.lang.Boolean))(
        _.isMainNode
      )
      .optionallyWith(
        numNodes.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.numNodes)
      .optionallyWith(
        nodeIndex.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.nodeIndex)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.NodePropertiesSummary.ReadOnly =
    zio.aws.batch.model.NodePropertiesSummary.wrap(buildAwsValue())
}
object NodePropertiesSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.NodePropertiesSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.NodePropertiesSummary =
      zio.aws.batch.model.NodePropertiesSummary(
        isMainNode.map(value => value),
        numNodes.map(value => value),
        nodeIndex.map(value => value)
      )
    def isMainNode: Option[Boolean]
    def numNodes: Option[Integer]
    def nodeIndex: Option[Integer]
    def getIsMainNode: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isMainNode", isMainNode)
    def getNumNodes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numNodes", numNodes)
    def getNodeIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("nodeIndex", nodeIndex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.NodePropertiesSummary
  ) extends zio.aws.batch.model.NodePropertiesSummary.ReadOnly {
    override val isMainNode: Option[Boolean] =
      scala.Option(impl.isMainNode()).map(value => value: Boolean)
    override val numNodes: Option[Integer] = scala
      .Option(impl.numNodes())
      .map(value => zio.aws.batch.model.primitives.Integer(value))
    override val nodeIndex: Option[Integer] = scala
      .Option(impl.nodeIndex())
      .map(value => zio.aws.batch.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.NodePropertiesSummary
  ): zio.aws.batch.model.NodePropertiesSummary.ReadOnly = new Wrapper(impl)
}
