package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListSchedulingPoliciesResponse(
    schedulingPolicies: Option[
      Iterable[zio.aws.batch.model.SchedulingPolicyListingDetail]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesResponse = {
    import ListSchedulingPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesResponse
      .builder()
      .optionallyWith(
        schedulingPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.schedulingPolicies)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ListSchedulingPoliciesResponse.ReadOnly =
    zio.aws.batch.model.ListSchedulingPoliciesResponse.wrap(buildAwsValue())
}
object ListSchedulingPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ListSchedulingPoliciesResponse =
      zio.aws.batch.model.ListSchedulingPoliciesResponse(
        schedulingPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def schedulingPolicies: Option[
      List[zio.aws.batch.model.SchedulingPolicyListingDetail.ReadOnly]
    ]
    def nextToken: Option[String]
    def getSchedulingPolicies: ZIO[Any, AwsError, List[
      zio.aws.batch.model.SchedulingPolicyListingDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("schedulingPolicies", schedulingPolicies)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesResponse
  ) extends zio.aws.batch.model.ListSchedulingPoliciesResponse.ReadOnly {
    override val schedulingPolicies: Option[
      List[zio.aws.batch.model.SchedulingPolicyListingDetail.ReadOnly]
    ] = scala
      .Option(impl.schedulingPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.batch.model.SchedulingPolicyListingDetail.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesResponse
  ): zio.aws.batch.model.ListSchedulingPoliciesResponse.ReadOnly = new Wrapper(
    impl
  )
}
