package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeSchedulingPoliciesRequest(arns: Iterable[String]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.DescribeSchedulingPoliciesRequest = {
    import DescribeSchedulingPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.DescribeSchedulingPoliciesRequest
      .builder()
      .arns(arns.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.batch.model.DescribeSchedulingPoliciesRequest.ReadOnly =
    zio.aws.batch.model.DescribeSchedulingPoliciesRequest.wrap(buildAwsValue())
}
object DescribeSchedulingPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.DescribeSchedulingPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.DescribeSchedulingPoliciesRequest =
      zio.aws.batch.model.DescribeSchedulingPoliciesRequest(arns)
    def arns: List[String]
    def getArns: ZIO[Any, Nothing, List[String]] = ZIO.succeed(arns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.DescribeSchedulingPoliciesRequest
  ) extends zio.aws.batch.model.DescribeSchedulingPoliciesRequest.ReadOnly {
    override val arns: List[String] = impl
      .arns()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.DescribeSchedulingPoliciesRequest
  ): zio.aws.batch.model.DescribeSchedulingPoliciesRequest.ReadOnly =
    new Wrapper(impl)
}
