package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NodePropertyOverride(
    targetNodes: String,
    containerOverrides: Option[zio.aws.batch.model.ContainerOverrides] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.NodePropertyOverride = {
    import NodePropertyOverride.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.NodePropertyOverride
      .builder()
      .targetNodes(targetNodes: java.lang.String)
      .optionallyWith(containerOverrides.map(value => value.buildAwsValue()))(
        _.containerOverrides
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.NodePropertyOverride.ReadOnly =
    zio.aws.batch.model.NodePropertyOverride.wrap(buildAwsValue())
}
object NodePropertyOverride {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.NodePropertyOverride
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.NodePropertyOverride =
      zio.aws.batch.model.NodePropertyOverride(
        targetNodes,
        containerOverrides.map(value => value.asEditable)
      )
    def targetNodes: String
    def containerOverrides
        : Option[zio.aws.batch.model.ContainerOverrides.ReadOnly]
    def getTargetNodes: ZIO[Any, Nothing, String] = ZIO.succeed(targetNodes)
    def getContainerOverrides
        : ZIO[Any, AwsError, zio.aws.batch.model.ContainerOverrides.ReadOnly] =
      AwsError.unwrapOptionField("containerOverrides", containerOverrides)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.NodePropertyOverride
  ) extends zio.aws.batch.model.NodePropertyOverride.ReadOnly {
    override val targetNodes: String = impl.targetNodes(): String
    override val containerOverrides
        : Option[zio.aws.batch.model.ContainerOverrides.ReadOnly] = scala
      .Option(impl.containerOverrides())
      .map(value => zio.aws.batch.model.ContainerOverrides.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.NodePropertyOverride
  ): zio.aws.batch.model.NodePropertyOverride.ReadOnly = new Wrapper(impl)
}
