package zio.aws.batch.model
import zio.aws.batch.model.primitives.{TagValue, TagKey, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class JobDetail(
    jobArn: Option[String] = None,
    jobName: String,
    jobId: String,
    jobQueue: String,
    status: zio.aws.batch.model.JobStatus,
    shareIdentifier: Option[String] = None,
    schedulingPriority: Option[Integer] = None,
    attempts: Option[Iterable[zio.aws.batch.model.AttemptDetail]] = None,
    statusReason: Option[String] = None,
    createdAt: Option[Long] = None,
    retryStrategy: Option[zio.aws.batch.model.RetryStrategy] = None,
    startedAt: Long,
    stoppedAt: Option[Long] = None,
    dependsOn: Option[Iterable[zio.aws.batch.model.JobDependency]] = None,
    jobDefinition: String,
    parameters: Option[Map[String, String]] = None,
    container: Option[zio.aws.batch.model.ContainerDetail] = None,
    nodeDetails: Option[zio.aws.batch.model.NodeDetails] = None,
    nodeProperties: Option[zio.aws.batch.model.NodeProperties] = None,
    arrayProperties: Option[zio.aws.batch.model.ArrayPropertiesDetail] = None,
    timeout: Option[zio.aws.batch.model.JobTimeout] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    propagateTags: Option[Boolean] = None,
    platformCapabilities: Option[
      Iterable[zio.aws.batch.model.PlatformCapability]
    ] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.batch.model.JobDetail = {
    import JobDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.JobDetail
      .builder()
      .optionallyWith(jobArn.map(value => value: java.lang.String))(_.jobArn)
      .jobName(jobName: java.lang.String)
      .jobId(jobId: java.lang.String)
      .jobQueue(jobQueue: java.lang.String)
      .status(status.unwrap)
      .optionallyWith(shareIdentifier.map(value => value: java.lang.String))(
        _.shareIdentifier
      )
      .optionallyWith(
        schedulingPriority.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.schedulingPriority)
      .optionallyWith(
        attempts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attempts)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .optionallyWith(createdAt.map(value => value: java.lang.Long))(
        _.createdAt
      )
      .optionallyWith(retryStrategy.map(value => value.buildAwsValue()))(
        _.retryStrategy
      )
      .startedAt(startedAt: java.lang.Long)
      .optionallyWith(stoppedAt.map(value => value: java.lang.Long))(
        _.stoppedAt
      )
      .optionallyWith(
        dependsOn.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dependsOn)
      .jobDefinition(jobDefinition: java.lang.String)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(container.map(value => value.buildAwsValue()))(
        _.container
      )
      .optionallyWith(nodeDetails.map(value => value.buildAwsValue()))(
        _.nodeDetails
      )
      .optionallyWith(nodeProperties.map(value => value.buildAwsValue()))(
        _.nodeProperties
      )
      .optionallyWith(arrayProperties.map(value => value.buildAwsValue()))(
        _.arrayProperties
      )
      .optionallyWith(timeout.map(value => value.buildAwsValue()))(_.timeout)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(propagateTags.map(value => value: java.lang.Boolean))(
        _.propagateTags
      )
      .optionallyWith(
        platformCapabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.platformCapabilitiesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.JobDetail.ReadOnly =
    zio.aws.batch.model.JobDetail.wrap(buildAwsValue())
}
object JobDetail {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.batch.model.JobDetail] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.JobDetail =
      zio.aws.batch.model.JobDetail(
        jobArn.map(value => value),
        jobName,
        jobId,
        jobQueue,
        status,
        shareIdentifier.map(value => value),
        schedulingPriority.map(value => value),
        attempts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statusReason.map(value => value),
        createdAt.map(value => value),
        retryStrategy.map(value => value.asEditable),
        startedAt,
        stoppedAt.map(value => value),
        dependsOn.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        jobDefinition,
        parameters.map(value => value),
        container.map(value => value.asEditable),
        nodeDetails.map(value => value.asEditable),
        nodeProperties.map(value => value.asEditable),
        arrayProperties.map(value => value.asEditable),
        timeout.map(value => value.asEditable),
        tags.map(value => value),
        propagateTags.map(value => value),
        platformCapabilities.map(value => value)
      )
    def jobArn: Option[String]
    def jobName: String
    def jobId: String
    def jobQueue: String
    def status: zio.aws.batch.model.JobStatus
    def shareIdentifier: Option[String]
    def schedulingPriority: Option[Integer]
    def attempts: Option[List[zio.aws.batch.model.AttemptDetail.ReadOnly]]
    def statusReason: Option[String]
    def createdAt: Option[Long]
    def retryStrategy: Option[zio.aws.batch.model.RetryStrategy.ReadOnly]
    def startedAt: Long
    def stoppedAt: Option[Long]
    def dependsOn: Option[List[zio.aws.batch.model.JobDependency.ReadOnly]]
    def jobDefinition: String
    def parameters: Option[Map[String, String]]
    def container: Option[zio.aws.batch.model.ContainerDetail.ReadOnly]
    def nodeDetails: Option[zio.aws.batch.model.NodeDetails.ReadOnly]
    def nodeProperties: Option[zio.aws.batch.model.NodeProperties.ReadOnly]
    def arrayProperties
        : Option[zio.aws.batch.model.ArrayPropertiesDetail.ReadOnly]
    def timeout: Option[zio.aws.batch.model.JobTimeout.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def propagateTags: Option[Boolean]
    def platformCapabilities
        : Option[List[zio.aws.batch.model.PlatformCapability]]
    def getJobArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getJobName: ZIO[Any, Nothing, String] = ZIO.succeed(jobName)
    def getJobId: ZIO[Any, Nothing, String] = ZIO.succeed(jobId)
    def getJobQueue: ZIO[Any, Nothing, String] = ZIO.succeed(jobQueue)
    def getStatus: ZIO[Any, Nothing, zio.aws.batch.model.JobStatus] =
      ZIO.succeed(status)
    def getShareIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("shareIdentifier", shareIdentifier)
    def getSchedulingPriority: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("schedulingPriority", schedulingPriority)
    def getAttempts
        : ZIO[Any, AwsError, List[zio.aws.batch.model.AttemptDetail.ReadOnly]] =
      AwsError.unwrapOptionField("attempts", attempts)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getCreatedAt: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getRetryStrategy
        : ZIO[Any, AwsError, zio.aws.batch.model.RetryStrategy.ReadOnly] =
      AwsError.unwrapOptionField("retryStrategy", retryStrategy)
    def getStartedAt: ZIO[Any, Nothing, Long] = ZIO.succeed(startedAt)
    def getStoppedAt: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("stoppedAt", stoppedAt)
    def getDependsOn
        : ZIO[Any, AwsError, List[zio.aws.batch.model.JobDependency.ReadOnly]] =
      AwsError.unwrapOptionField("dependsOn", dependsOn)
    def getJobDefinition: ZIO[Any, Nothing, String] = ZIO.succeed(jobDefinition)
    def getParameters: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getContainer
        : ZIO[Any, AwsError, zio.aws.batch.model.ContainerDetail.ReadOnly] =
      AwsError.unwrapOptionField("container", container)
    def getNodeDetails
        : ZIO[Any, AwsError, zio.aws.batch.model.NodeDetails.ReadOnly] =
      AwsError.unwrapOptionField("nodeDetails", nodeDetails)
    def getNodeProperties
        : ZIO[Any, AwsError, zio.aws.batch.model.NodeProperties.ReadOnly] =
      AwsError.unwrapOptionField("nodeProperties", nodeProperties)
    def getArrayProperties: ZIO[
      Any,
      AwsError,
      zio.aws.batch.model.ArrayPropertiesDetail.ReadOnly
    ] = AwsError.unwrapOptionField("arrayProperties", arrayProperties)
    def getTimeout
        : ZIO[Any, AwsError, zio.aws.batch.model.JobTimeout.ReadOnly] =
      AwsError.unwrapOptionField("timeout", timeout)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPropagateTags: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("propagateTags", propagateTags)
    def getPlatformCapabilities
        : ZIO[Any, AwsError, List[zio.aws.batch.model.PlatformCapability]] =
      AwsError.unwrapOptionField("platformCapabilities", platformCapabilities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.JobDetail
  ) extends zio.aws.batch.model.JobDetail.ReadOnly {
    override val jobArn: Option[String] =
      scala.Option(impl.jobArn()).map(value => value: String)
    override val jobName: String = impl.jobName(): String
    override val jobId: String = impl.jobId(): String
    override val jobQueue: String = impl.jobQueue(): String
    override val status: zio.aws.batch.model.JobStatus =
      zio.aws.batch.model.JobStatus.wrap(impl.status())
    override val shareIdentifier: Option[String] =
      scala.Option(impl.shareIdentifier()).map(value => value: String)
    override val schedulingPriority: Option[Integer] = scala
      .Option(impl.schedulingPriority())
      .map(value => zio.aws.batch.model.primitives.Integer(value))
    override val attempts
        : Option[List[zio.aws.batch.model.AttemptDetail.ReadOnly]] = scala
      .Option(impl.attempts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.batch.model.AttemptDetail.wrap(item)
        }.toList
      )
    override val statusReason: Option[String] =
      scala.Option(impl.statusReason()).map(value => value: String)
    override val createdAt: Option[Long] =
      scala.Option(impl.createdAt()).map(value => value: Long)
    override val retryStrategy
        : Option[zio.aws.batch.model.RetryStrategy.ReadOnly] = scala
      .Option(impl.retryStrategy())
      .map(value => zio.aws.batch.model.RetryStrategy.wrap(value))
    override val startedAt: Long = impl.startedAt(): Long
    override val stoppedAt: Option[Long] =
      scala.Option(impl.stoppedAt()).map(value => value: Long)
    override val dependsOn
        : Option[List[zio.aws.batch.model.JobDependency.ReadOnly]] = scala
      .Option(impl.dependsOn())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.batch.model.JobDependency.wrap(item)
        }.toList
      )
    override val jobDefinition: String = impl.jobDefinition(): String
    override val parameters: Option[Map[String, String]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val container
        : Option[zio.aws.batch.model.ContainerDetail.ReadOnly] = scala
      .Option(impl.container())
      .map(value => zio.aws.batch.model.ContainerDetail.wrap(value))
    override val nodeDetails: Option[zio.aws.batch.model.NodeDetails.ReadOnly] =
      scala
        .Option(impl.nodeDetails())
        .map(value => zio.aws.batch.model.NodeDetails.wrap(value))
    override val nodeProperties
        : Option[zio.aws.batch.model.NodeProperties.ReadOnly] = scala
      .Option(impl.nodeProperties())
      .map(value => zio.aws.batch.model.NodeProperties.wrap(value))
    override val arrayProperties
        : Option[zio.aws.batch.model.ArrayPropertiesDetail.ReadOnly] = scala
      .Option(impl.arrayProperties())
      .map(value => zio.aws.batch.model.ArrayPropertiesDetail.wrap(value))
    override val timeout: Option[zio.aws.batch.model.JobTimeout.ReadOnly] =
      scala
        .Option(impl.timeout())
        .map(value => zio.aws.batch.model.JobTimeout.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.batch.model.primitives
              .TagKey(key) -> zio.aws.batch.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val propagateTags: Option[Boolean] =
      scala.Option(impl.propagateTags()).map(value => value: Boolean)
    override val platformCapabilities
        : Option[List[zio.aws.batch.model.PlatformCapability]] = scala
      .Option(impl.platformCapabilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.batch.model.PlatformCapability.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.JobDetail
  ): zio.aws.batch.model.JobDetail.ReadOnly = new Wrapper(impl)
}
