package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ArrayProperties(size: Option[Integer] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ArrayProperties = {
    import ArrayProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ArrayProperties
      .builder()
      .optionallyWith(
        size.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.size)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ArrayProperties.ReadOnly =
    zio.aws.batch.model.ArrayProperties.wrap(buildAwsValue())
}
object ArrayProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ArrayProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ArrayProperties =
      zio.aws.batch.model.ArrayProperties(size.map(value => value))
    def size: Option[Integer]
    def getSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("size", size)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ArrayProperties
  ) extends zio.aws.batch.model.ArrayProperties.ReadOnly {
    override val size: Option[Integer] = scala
      .Option(impl.size())
      .map(value => zio.aws.batch.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ArrayProperties
  ): zio.aws.batch.model.ArrayProperties.ReadOnly = new Wrapper(impl)
}
