package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NetworkConfiguration(
    assignPublicIp: Option[zio.aws.batch.model.AssignPublicIp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.NetworkConfiguration = {
    import NetworkConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.NetworkConfiguration
      .builder()
      .optionallyWith(assignPublicIp.map(value => value.unwrap))(
        _.assignPublicIp
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.NetworkConfiguration.ReadOnly =
    zio.aws.batch.model.NetworkConfiguration.wrap(buildAwsValue())
}
object NetworkConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.NetworkConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.NetworkConfiguration =
      zio.aws.batch.model
        .NetworkConfiguration(assignPublicIp.map(value => value))
    def assignPublicIp: Option[zio.aws.batch.model.AssignPublicIp]
    def getAssignPublicIp
        : ZIO[Any, AwsError, zio.aws.batch.model.AssignPublicIp] =
      AwsError.unwrapOptionField("assignPublicIp", assignPublicIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.NetworkConfiguration
  ) extends zio.aws.batch.model.NetworkConfiguration.ReadOnly {
    override val assignPublicIp: Option[zio.aws.batch.model.AssignPublicIp] =
      scala
        .Option(impl.assignPublicIp())
        .map(value => zio.aws.batch.model.AssignPublicIp.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.NetworkConfiguration
  ): zio.aws.batch.model.NetworkConfiguration.ReadOnly = new Wrapper(impl)
}
