package zio.aws.batch.model
import scala.jdk.CollectionConverters._
sealed trait JQStatus {
  def unwrap: software.amazon.awssdk.services.batch.model.JQStatus
}
object JQStatus {
  def wrap(
      value: software.amazon.awssdk.services.batch.model.JQStatus
  ): zio.aws.batch.model.JQStatus = value match {
    case software.amazon.awssdk.services.batch.model.JQStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.batch.model.JQStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.batch.model.JQStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.batch.model.JQStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.batch.model.JQStatus.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.batch.model.JQStatus.VALID =>
      val r = VALID
      r
    case software.amazon.awssdk.services.batch.model.JQStatus.INVALID =>
      val r = INVALID
      r
  }
  case object unknownToSdkVersion extends zio.aws.batch.model.JQStatus {
    override def unwrap: software.amazon.awssdk.services.batch.model.JQStatus =
      software.amazon.awssdk.services.batch.model.JQStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.batch.model.JQStatus {
    override def unwrap: software.amazon.awssdk.services.batch.model.JQStatus =
      software.amazon.awssdk.services.batch.model.JQStatus.CREATING
  }
  case object UPDATING extends zio.aws.batch.model.JQStatus {
    override def unwrap: software.amazon.awssdk.services.batch.model.JQStatus =
      software.amazon.awssdk.services.batch.model.JQStatus.UPDATING
  }
  case object DELETING extends zio.aws.batch.model.JQStatus {
    override def unwrap: software.amazon.awssdk.services.batch.model.JQStatus =
      software.amazon.awssdk.services.batch.model.JQStatus.DELETING
  }
  case object DELETED extends zio.aws.batch.model.JQStatus {
    override def unwrap: software.amazon.awssdk.services.batch.model.JQStatus =
      software.amazon.awssdk.services.batch.model.JQStatus.DELETED
  }
  case object VALID extends zio.aws.batch.model.JQStatus {
    override def unwrap: software.amazon.awssdk.services.batch.model.JQStatus =
      software.amazon.awssdk.services.batch.model.JQStatus.VALID
  }
  case object INVALID extends zio.aws.batch.model.JQStatus {
    override def unwrap: software.amazon.awssdk.services.batch.model.JQStatus =
      software.amazon.awssdk.services.batch.model.JQStatus.INVALID
  }
}
