package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EFSAuthorizationConfig(
    accessPointId: Option[String] = None,
    iam: Option[zio.aws.batch.model.EFSAuthorizationConfigIAM] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.EFSAuthorizationConfig = {
    import EFSAuthorizationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EFSAuthorizationConfig
      .builder()
      .optionallyWith(accessPointId.map(value => value: java.lang.String))(
        _.accessPointId
      )
      .optionallyWith(iam.map(value => value.unwrap))(_.iam)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.EFSAuthorizationConfig.ReadOnly =
    zio.aws.batch.model.EFSAuthorizationConfig.wrap(buildAwsValue())
}
object EFSAuthorizationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.EFSAuthorizationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EFSAuthorizationConfig =
      zio.aws.batch.model.EFSAuthorizationConfig(
        accessPointId.map(value => value),
        iam.map(value => value)
      )
    def accessPointId: Option[String]
    def iam: Option[zio.aws.batch.model.EFSAuthorizationConfigIAM]
    def getAccessPointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accessPointId", accessPointId)
    def getIam
        : ZIO[Any, AwsError, zio.aws.batch.model.EFSAuthorizationConfigIAM] =
      AwsError.unwrapOptionField("iam", iam)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EFSAuthorizationConfig
  ) extends zio.aws.batch.model.EFSAuthorizationConfig.ReadOnly {
    override val accessPointId: Option[String] =
      scala.Option(impl.accessPointId()).map(value => value: String)
    override val iam: Option[zio.aws.batch.model.EFSAuthorizationConfigIAM] =
      scala
        .Option(impl.iam())
        .map(value => zio.aws.batch.model.EFSAuthorizationConfigIAM.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EFSAuthorizationConfig
  ): zio.aws.batch.model.EFSAuthorizationConfig.ReadOnly = new Wrapper(impl)
}
