package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AttemptContainerDetail(
    containerInstanceArn: Option[String] = None,
    taskArn: Option[String] = None,
    exitCode: Option[Integer] = None,
    reason: Option[String] = None,
    logStreamName: Option[String] = None,
    networkInterfaces: Option[Iterable[zio.aws.batch.model.NetworkInterface]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.AttemptContainerDetail = {
    import AttemptContainerDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.AttemptContainerDetail
      .builder()
      .optionallyWith(
        containerInstanceArn.map(value => value: java.lang.String)
      )(_.containerInstanceArn)
      .optionallyWith(taskArn.map(value => value: java.lang.String))(_.taskArn)
      .optionallyWith(
        exitCode.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.exitCode)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .optionallyWith(logStreamName.map(value => value: java.lang.String))(
        _.logStreamName
      )
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.AttemptContainerDetail.ReadOnly =
    zio.aws.batch.model.AttemptContainerDetail.wrap(buildAwsValue())
}
object AttemptContainerDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.AttemptContainerDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.AttemptContainerDetail =
      zio.aws.batch.model.AttemptContainerDetail(
        containerInstanceArn.map(value => value),
        taskArn.map(value => value),
        exitCode.map(value => value),
        reason.map(value => value),
        logStreamName.map(value => value),
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def containerInstanceArn: Option[String]
    def taskArn: Option[String]
    def exitCode: Option[Integer]
    def reason: Option[String]
    def logStreamName: Option[String]
    def networkInterfaces
        : Option[List[zio.aws.batch.model.NetworkInterface.ReadOnly]]
    def getContainerInstanceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerInstanceArn", containerInstanceArn)
    def getTaskArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskArn", taskArn)
    def getExitCode: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("exitCode", exitCode)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
    def getLogStreamName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logStreamName", logStreamName)
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.batch.model.NetworkInterface.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.AttemptContainerDetail
  ) extends zio.aws.batch.model.AttemptContainerDetail.ReadOnly {
    override val containerInstanceArn: Option[String] =
      scala.Option(impl.containerInstanceArn()).map(value => value: String)
    override val taskArn: Option[String] =
      scala.Option(impl.taskArn()).map(value => value: String)
    override val exitCode: Option[Integer] = scala
      .Option(impl.exitCode())
      .map(value => zio.aws.batch.model.primitives.Integer(value))
    override val reason: Option[String] =
      scala.Option(impl.reason()).map(value => value: String)
    override val logStreamName: Option[String] =
      scala.Option(impl.logStreamName()).map(value => value: String)
    override val networkInterfaces
        : Option[List[zio.aws.batch.model.NetworkInterface.ReadOnly]] = scala
      .Option(impl.networkInterfaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.batch.model.NetworkInterface.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.AttemptContainerDetail
  ): zio.aws.batch.model.AttemptContainerDetail.ReadOnly = new Wrapper(impl)
}
