package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NodeDetails(
    nodeIndex: Option[Integer] = None,
    isMainNode: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.NodeDetails = {
    import NodeDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.NodeDetails
      .builder()
      .optionallyWith(
        nodeIndex.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.nodeIndex)
      .optionallyWith(isMainNode.map(value => value: java.lang.Boolean))(
        _.isMainNode
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.NodeDetails.ReadOnly =
    zio.aws.batch.model.NodeDetails.wrap(buildAwsValue())
}
object NodeDetails {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.batch.model.NodeDetails] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.NodeDetails =
      zio.aws.batch.model.NodeDetails(
        nodeIndex.map(value => value),
        isMainNode.map(value => value)
      )
    def nodeIndex: Option[Integer]
    def isMainNode: Option[Boolean]
    def getNodeIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("nodeIndex", nodeIndex)
    def getIsMainNode: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isMainNode", isMainNode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.NodeDetails
  ) extends zio.aws.batch.model.NodeDetails.ReadOnly {
    override val nodeIndex: Option[Integer] = scala
      .Option(impl.nodeIndex())
      .map(value => zio.aws.batch.model.primitives.Integer(value))
    override val isMainNode: Option[Boolean] =
      scala.Option(impl.isMainNode()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.NodeDetails
  ): zio.aws.batch.model.NodeDetails.ReadOnly = new Wrapper(impl)
}
