package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class KeyValuePair(
    name: Option[String] = None,
    value: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.KeyValuePair = {
    import KeyValuePair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.KeyValuePair
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.KeyValuePair.ReadOnly =
    zio.aws.batch.model.KeyValuePair.wrap(buildAwsValue())
}
object KeyValuePair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.KeyValuePair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.KeyValuePair = zio.aws.batch.model
      .KeyValuePair(name.map(value => value), value.map(value => value))
    def name: Option[String]
    def value: Option[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.KeyValuePair
  ) extends zio.aws.batch.model.KeyValuePair.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.KeyValuePair
  ): zio.aws.batch.model.KeyValuePair.ReadOnly = new Wrapper(impl)
}
