package zio.aws.batch.model
import zio.aws.batch.model.primitives.{TagValue, TagKey, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ComputeEnvironmentDetail(
    computeEnvironmentName: String,
    computeEnvironmentArn: String,
    unmanagedvCpus: Option[Integer] = None,
    ecsClusterArn: String,
    tags: Option[Map[TagKey, TagValue]] = None,
    `type`: Option[zio.aws.batch.model.CEType] = None,
    state: Option[zio.aws.batch.model.CEState] = None,
    status: Option[zio.aws.batch.model.CEStatus] = None,
    statusReason: Option[String] = None,
    computeResources: Option[zio.aws.batch.model.ComputeResource] = None,
    serviceRole: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ComputeEnvironmentDetail = {
    import ComputeEnvironmentDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ComputeEnvironmentDetail
      .builder()
      .computeEnvironmentName(computeEnvironmentName: java.lang.String)
      .computeEnvironmentArn(computeEnvironmentArn: java.lang.String)
      .optionallyWith(
        unmanagedvCpus.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.unmanagedvCpus)
      .ecsClusterArn(ecsClusterArn: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .optionallyWith(computeResources.map(value => value.buildAwsValue()))(
        _.computeResources
      )
      .optionallyWith(serviceRole.map(value => value: java.lang.String))(
        _.serviceRole
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ComputeEnvironmentDetail.ReadOnly =
    zio.aws.batch.model.ComputeEnvironmentDetail.wrap(buildAwsValue())
}
object ComputeEnvironmentDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ComputeEnvironmentDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ComputeEnvironmentDetail =
      zio.aws.batch.model.ComputeEnvironmentDetail(
        computeEnvironmentName,
        computeEnvironmentArn,
        unmanagedvCpus.map(value => value),
        ecsClusterArn,
        tags.map(value => value),
        `type`.map(value => value),
        state.map(value => value),
        status.map(value => value),
        statusReason.map(value => value),
        computeResources.map(value => value.asEditable),
        serviceRole.map(value => value)
      )
    def computeEnvironmentName: String
    def computeEnvironmentArn: String
    def unmanagedvCpus: Option[Integer]
    def ecsClusterArn: String
    def tags: Option[Map[TagKey, TagValue]]
    def `type`: Option[zio.aws.batch.model.CEType]
    def state: Option[zio.aws.batch.model.CEState]
    def status: Option[zio.aws.batch.model.CEStatus]
    def statusReason: Option[String]
    def computeResources: Option[zio.aws.batch.model.ComputeResource.ReadOnly]
    def serviceRole: Option[String]
    def getComputeEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(computeEnvironmentName)
    def getComputeEnvironmentArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(computeEnvironmentArn)
    def getUnmanagedvCpus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("unmanagedvCpus", unmanagedvCpus)
    def getEcsClusterArn: ZIO[Any, Nothing, String] = ZIO.succeed(ecsClusterArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, AwsError, zio.aws.batch.model.CEType] =
      AwsError.unwrapOptionField("type", `type`)
    def getState: ZIO[Any, AwsError, zio.aws.batch.model.CEState] =
      AwsError.unwrapOptionField("state", state)
    def getStatus: ZIO[Any, AwsError, zio.aws.batch.model.CEStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getComputeResources
        : ZIO[Any, AwsError, zio.aws.batch.model.ComputeResource.ReadOnly] =
      AwsError.unwrapOptionField("computeResources", computeResources)
    def getServiceRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ComputeEnvironmentDetail
  ) extends zio.aws.batch.model.ComputeEnvironmentDetail.ReadOnly {
    override val computeEnvironmentName: String =
      impl.computeEnvironmentName(): String
    override val computeEnvironmentArn: String =
      impl.computeEnvironmentArn(): String
    override val unmanagedvCpus: Option[Integer] = scala
      .Option(impl.unmanagedvCpus())
      .map(value => zio.aws.batch.model.primitives.Integer(value))
    override val ecsClusterArn: String = impl.ecsClusterArn(): String
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.batch.model.primitives
              .TagKey(key) -> zio.aws.batch.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val `type`: Option[zio.aws.batch.model.CEType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.batch.model.CEType.wrap(value))
    override val state: Option[zio.aws.batch.model.CEState] = scala
      .Option(impl.state())
      .map(value => zio.aws.batch.model.CEState.wrap(value))
    override val status: Option[zio.aws.batch.model.CEStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.batch.model.CEStatus.wrap(value))
    override val statusReason: Option[String] =
      scala.Option(impl.statusReason()).map(value => value: String)
    override val computeResources
        : Option[zio.aws.batch.model.ComputeResource.ReadOnly] = scala
      .Option(impl.computeResources())
      .map(value => zio.aws.batch.model.ComputeResource.wrap(value))
    override val serviceRole: Option[String] =
      scala.Option(impl.serviceRole()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ComputeEnvironmentDetail
  ): zio.aws.batch.model.ComputeEnvironmentDetail.ReadOnly = new Wrapper(impl)
}
