package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListSchedulingPoliciesRequest(
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesRequest = {
    import ListSchedulingPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ListSchedulingPoliciesRequest.ReadOnly =
    zio.aws.batch.model.ListSchedulingPoliciesRequest.wrap(buildAwsValue())
}
object ListSchedulingPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ListSchedulingPoliciesRequest =
      zio.aws.batch.model.ListSchedulingPoliciesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesRequest
  ) extends zio.aws.batch.model.ListSchedulingPoliciesRequest.ReadOnly {
    override val maxResults: Option[Integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.batch.model.primitives.Integer(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesRequest
  ): zio.aws.batch.model.ListSchedulingPoliciesRequest.ReadOnly = new Wrapper(
    impl
  )
}
