package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeJobQueuesRequest(
    jobQueues: Option[Iterable[String]] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.DescribeJobQueuesRequest = {
    import DescribeJobQueuesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.DescribeJobQueuesRequest
      .builder()
      .optionallyWith(
        jobQueues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.jobQueues)
      .optionallyWith(
        maxResults.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.DescribeJobQueuesRequest.ReadOnly =
    zio.aws.batch.model.DescribeJobQueuesRequest.wrap(buildAwsValue())
}
object DescribeJobQueuesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.DescribeJobQueuesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.DescribeJobQueuesRequest =
      zio.aws.batch.model.DescribeJobQueuesRequest(
        jobQueues.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def jobQueues: Option[List[String]]
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def getJobQueues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("jobQueues", jobQueues)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.DescribeJobQueuesRequest
  ) extends zio.aws.batch.model.DescribeJobQueuesRequest.ReadOnly {
    override val jobQueues: Option[List[String]] = scala
      .Option(impl.jobQueues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val maxResults: Option[Integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.batch.model.primitives.Integer(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.DescribeJobQueuesRequest
  ): zio.aws.batch.model.DescribeJobQueuesRequest.ReadOnly = new Wrapper(impl)
}
