package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ContainerOverrides(
    vcpus: Option[Integer] = None,
    memory: Option[Integer] = None,
    command: Option[Iterable[String]] = None,
    instanceType: Option[String] = None,
    environment: Option[Iterable[zio.aws.batch.model.KeyValuePair]] = None,
    resourceRequirements: Option[
      Iterable[zio.aws.batch.model.ResourceRequirement]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ContainerOverrides = {
    import ContainerOverrides.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ContainerOverrides
      .builder()
      .optionallyWith(
        vcpus.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.vcpus)
      .optionallyWith(
        memory.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.memory)
      .optionallyWith(
        command.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.command)
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(
        environment.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environment)
      .optionallyWith(
        resourceRequirements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceRequirements)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ContainerOverrides.ReadOnly =
    zio.aws.batch.model.ContainerOverrides.wrap(buildAwsValue())
}
object ContainerOverrides {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ContainerOverrides
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ContainerOverrides =
      zio.aws.batch.model.ContainerOverrides(
        vcpus.map(value => value),
        memory.map(value => value),
        command.map(value => value),
        instanceType.map(value => value),
        environment.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceRequirements.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def vcpus: Option[Integer]
    def memory: Option[Integer]
    def command: Option[List[String]]
    def instanceType: Option[String]
    def environment: Option[List[zio.aws.batch.model.KeyValuePair.ReadOnly]]
    def resourceRequirements
        : Option[List[zio.aws.batch.model.ResourceRequirement.ReadOnly]]
    def getVcpus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("vcpus", vcpus)
    def getMemory: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("memory", memory)
    def getCommand: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("command", command)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getEnvironment
        : ZIO[Any, AwsError, List[zio.aws.batch.model.KeyValuePair.ReadOnly]] =
      AwsError.unwrapOptionField("environment", environment)
    def getResourceRequirements: ZIO[Any, AwsError, List[
      zio.aws.batch.model.ResourceRequirement.ReadOnly
    ]] =
      AwsError.unwrapOptionField("resourceRequirements", resourceRequirements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ContainerOverrides
  ) extends zio.aws.batch.model.ContainerOverrides.ReadOnly {
    override val vcpus: Option[Integer] = scala
      .Option(impl.vcpus())
      .map(value => zio.aws.batch.model.primitives.Integer(value))
    override val memory: Option[Integer] = scala
      .Option(impl.memory())
      .map(value => zio.aws.batch.model.primitives.Integer(value))
    override val command: Option[List[String]] = scala
      .Option(impl.command())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val instanceType: Option[String] =
      scala.Option(impl.instanceType()).map(value => value: String)
    override val environment
        : Option[List[zio.aws.batch.model.KeyValuePair.ReadOnly]] = scala
      .Option(impl.environment())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.batch.model.KeyValuePair.wrap(item)
        }.toList
      )
    override val resourceRequirements
        : Option[List[zio.aws.batch.model.ResourceRequirement.ReadOnly]] = scala
      .Option(impl.resourceRequirements())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.batch.model.ResourceRequirement.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ContainerOverrides
  ): zio.aws.batch.model.ContainerOverrides.ReadOnly = new Wrapper(impl)
}
