package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AttemptDetail(
    container: Option[zio.aws.batch.model.AttemptContainerDetail] = None,
    startedAt: Option[Long] = None,
    stoppedAt: Option[Long] = None,
    statusReason: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.AttemptDetail = {
    import AttemptDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.AttemptDetail
      .builder()
      .optionallyWith(container.map(value => value.buildAwsValue()))(
        _.container
      )
      .optionallyWith(startedAt.map(value => value: java.lang.Long))(
        _.startedAt
      )
      .optionallyWith(stoppedAt.map(value => value: java.lang.Long))(
        _.stoppedAt
      )
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.AttemptDetail.ReadOnly =
    zio.aws.batch.model.AttemptDetail.wrap(buildAwsValue())
}
object AttemptDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.AttemptDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.AttemptDetail =
      zio.aws.batch.model.AttemptDetail(
        container.map(value => value.asEditable),
        startedAt.map(value => value),
        stoppedAt.map(value => value),
        statusReason.map(value => value)
      )
    def container: Option[zio.aws.batch.model.AttemptContainerDetail.ReadOnly]
    def startedAt: Option[Long]
    def stoppedAt: Option[Long]
    def statusReason: Option[String]
    def getContainer: ZIO[
      Any,
      AwsError,
      zio.aws.batch.model.AttemptContainerDetail.ReadOnly
    ] = AwsError.unwrapOptionField("container", container)
    def getStartedAt: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getStoppedAt: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("stoppedAt", stoppedAt)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.AttemptDetail
  ) extends zio.aws.batch.model.AttemptDetail.ReadOnly {
    override val container
        : Option[zio.aws.batch.model.AttemptContainerDetail.ReadOnly] = scala
      .Option(impl.container())
      .map(value => zio.aws.batch.model.AttemptContainerDetail.wrap(value))
    override val startedAt: Option[Long] =
      scala.Option(impl.startedAt()).map(value => value: Long)
    override val stoppedAt: Option[Long] =
      scala.Option(impl.stoppedAt()).map(value => value: Long)
    override val statusReason: Option[String] =
      scala.Option(impl.statusReason()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.AttemptDetail
  ): zio.aws.batch.model.AttemptDetail.ReadOnly = new Wrapper(impl)
}
