package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateSchedulingPolicyRequest(
    arn: String,
    fairsharePolicy: Option[zio.aws.batch.model.FairsharePolicy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.UpdateSchedulingPolicyRequest = {
    import UpdateSchedulingPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.UpdateSchedulingPolicyRequest
      .builder()
      .arn(arn: java.lang.String)
      .optionallyWith(fairsharePolicy.map(value => value.buildAwsValue()))(
        _.fairsharePolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.UpdateSchedulingPolicyRequest.ReadOnly =
    zio.aws.batch.model.UpdateSchedulingPolicyRequest.wrap(buildAwsValue())
}
object UpdateSchedulingPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.UpdateSchedulingPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.UpdateSchedulingPolicyRequest =
      zio.aws.batch.model.UpdateSchedulingPolicyRequest(
        arn,
        fairsharePolicy.map(value => value.asEditable)
      )
    def arn: String
    def fairsharePolicy: Option[zio.aws.batch.model.FairsharePolicy.ReadOnly]
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getFairsharePolicy
        : ZIO[Any, AwsError, zio.aws.batch.model.FairsharePolicy.ReadOnly] =
      AwsError.unwrapOptionField("fairsharePolicy", fairsharePolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.UpdateSchedulingPolicyRequest
  ) extends zio.aws.batch.model.UpdateSchedulingPolicyRequest.ReadOnly {
    override val arn: String = impl.arn(): String
    override val fairsharePolicy
        : Option[zio.aws.batch.model.FairsharePolicy.ReadOnly] = scala
      .Option(impl.fairsharePolicy())
      .map(value => zio.aws.batch.model.FairsharePolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.UpdateSchedulingPolicyRequest
  ): zio.aws.batch.model.UpdateSchedulingPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
