package zio.aws.backupstorage.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class NotifyObjectCompleteResponse(
    objectChecksum: String,
    objectChecksumAlgorithm: zio.aws.backupstorage.model.SummaryChecksumAlgorithm
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupstorage.model.NotifyObjectCompleteResponse = {
    import NotifyObjectCompleteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupstorage.model.NotifyObjectCompleteResponse
      .builder()
      .objectChecksum(objectChecksum: java.lang.String)
      .objectChecksumAlgorithm(objectChecksumAlgorithm.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.backupstorage.model.NotifyObjectCompleteResponse.ReadOnly =
    zio.aws.backupstorage.model.NotifyObjectCompleteResponse
      .wrap(buildAwsValue())
}
object NotifyObjectCompleteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupstorage.model.NotifyObjectCompleteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupstorage.model.NotifyObjectCompleteResponse =
      zio.aws.backupstorage.model
        .NotifyObjectCompleteResponse(objectChecksum, objectChecksumAlgorithm)
    def objectChecksum: String
    def objectChecksumAlgorithm
        : zio.aws.backupstorage.model.SummaryChecksumAlgorithm
    def getObjectChecksum: ZIO[Any, Nothing, String] =
      ZIO.succeed(objectChecksum)
    def getObjectChecksumAlgorithm: ZIO[
      Any,
      Nothing,
      zio.aws.backupstorage.model.SummaryChecksumAlgorithm
    ] = ZIO.succeed(objectChecksumAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupstorage.model.NotifyObjectCompleteResponse
  ) extends zio.aws.backupstorage.model.NotifyObjectCompleteResponse.ReadOnly {
    override val objectChecksum: String = impl.objectChecksum(): String
    override val objectChecksumAlgorithm
        : zio.aws.backupstorage.model.SummaryChecksumAlgorithm =
      zio.aws.backupstorage.model.SummaryChecksumAlgorithm
        .wrap(impl.objectChecksumAlgorithm())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupstorage.model.NotifyObjectCompleteResponse
  ): zio.aws.backupstorage.model.NotifyObjectCompleteResponse.ReadOnly =
    new Wrapper(impl)
}
