package zio.aws.backupstorage.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutObjectRequest(
    backupJobId: String,
    objectName: String,
    metadataString: Optional[String] = Optional.Absent,
    inlineChunkLength: Optional[Long] = Optional.Absent,
    inlineChunkChecksum: Optional[String] = Optional.Absent,
    inlineChunkChecksumAlgorithm: Optional[String] = Optional.Absent,
    objectChecksum: Optional[String] = Optional.Absent,
    objectChecksumAlgorithm: Optional[
      zio.aws.backupstorage.model.SummaryChecksumAlgorithm
    ] = Optional.Absent,
    throwOnDuplicate: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupstorage.model.PutObjectRequest = {
    import PutObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupstorage.model.PutObjectRequest
      .builder()
      .backupJobId(backupJobId: java.lang.String)
      .objectName(objectName: java.lang.String)
      .optionallyWith(metadataString.map(value => value: java.lang.String))(
        _.metadataString
      )
      .optionallyWith(inlineChunkLength.map(value => value: java.lang.Long))(
        _.inlineChunkLength
      )
      .optionallyWith(
        inlineChunkChecksum.map(value => value: java.lang.String)
      )(_.inlineChunkChecksum)
      .optionallyWith(
        inlineChunkChecksumAlgorithm.map(value => value: java.lang.String)
      )(_.inlineChunkChecksumAlgorithm)
      .optionallyWith(objectChecksum.map(value => value: java.lang.String))(
        _.objectChecksum
      )
      .optionallyWith(objectChecksumAlgorithm.map(value => value.unwrap))(
        _.objectChecksumAlgorithm
      )
      .optionallyWith(throwOnDuplicate.map(value => value: java.lang.Boolean))(
        _.throwOnDuplicate
      )
      .build()
  }
  def asReadOnly: zio.aws.backupstorage.model.PutObjectRequest.ReadOnly =
    zio.aws.backupstorage.model.PutObjectRequest.wrap(buildAwsValue())
}
object PutObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupstorage.model.PutObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupstorage.model.PutObjectRequest =
      zio.aws.backupstorage.model.PutObjectRequest(
        backupJobId,
        objectName,
        metadataString.map(value => value),
        inlineChunkLength.map(value => value),
        inlineChunkChecksum.map(value => value),
        inlineChunkChecksumAlgorithm.map(value => value),
        objectChecksum.map(value => value),
        objectChecksumAlgorithm.map(value => value),
        throwOnDuplicate.map(value => value)
      )
    def backupJobId: String
    def objectName: String
    def metadataString: Optional[String]
    def inlineChunkLength: Optional[Long]
    def inlineChunkChecksum: Optional[String]
    def inlineChunkChecksumAlgorithm: Optional[String]
    def objectChecksum: Optional[String]
    def objectChecksumAlgorithm
        : Optional[zio.aws.backupstorage.model.SummaryChecksumAlgorithm]
    def throwOnDuplicate: Optional[Boolean]
    def getBackupJobId: ZIO[Any, Nothing, String] = ZIO.succeed(backupJobId)
    def getObjectName: ZIO[Any, Nothing, String] = ZIO.succeed(objectName)
    def getMetadataString: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("metadataString", metadataString)
    def getInlineChunkLength: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("inlineChunkLength", inlineChunkLength)
    def getInlineChunkChecksum: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("inlineChunkChecksum", inlineChunkChecksum)
    def getInlineChunkChecksumAlgorithm: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "inlineChunkChecksumAlgorithm",
        inlineChunkChecksumAlgorithm
      )
    def getObjectChecksum: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("objectChecksum", objectChecksum)
    def getObjectChecksumAlgorithm: ZIO[
      Any,
      AwsError,
      zio.aws.backupstorage.model.SummaryChecksumAlgorithm
    ] = AwsError.unwrapOptionField(
      "objectChecksumAlgorithm",
      objectChecksumAlgorithm
    )
    def getThrowOnDuplicate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("throwOnDuplicate", throwOnDuplicate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupstorage.model.PutObjectRequest
  ) extends zio.aws.backupstorage.model.PutObjectRequest.ReadOnly {
    override val backupJobId: String = impl.backupJobId(): String
    override val objectName: String = impl.objectName(): String
    override val metadataString: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.metadataString())
      .map(value => value: String)
    override val inlineChunkLength: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.inlineChunkLength())
      .map(value => value: Long)
    override val inlineChunkChecksum: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.inlineChunkChecksum())
      .map(value => value: String)
    override val inlineChunkChecksumAlgorithm: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inlineChunkChecksumAlgorithm())
        .map(value => value: String)
    override val objectChecksum: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.objectChecksum())
      .map(value => value: String)
    override val objectChecksumAlgorithm
        : Optional[zio.aws.backupstorage.model.SummaryChecksumAlgorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectChecksumAlgorithm())
        .map(value =>
          zio.aws.backupstorage.model.SummaryChecksumAlgorithm.wrap(value)
        )
    override val throwOnDuplicate: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.throwOnDuplicate())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupstorage.model.PutObjectRequest
  ): zio.aws.backupstorage.model.PutObjectRequest.ReadOnly = new Wrapper(impl)
}
