package zio.aws.backupstorage.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetChunkRequest(storageJobId: String, chunkToken: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupstorage.model.GetChunkRequest = {
    import GetChunkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupstorage.model.GetChunkRequest
      .builder()
      .storageJobId(storageJobId: java.lang.String)
      .chunkToken(chunkToken: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backupstorage.model.GetChunkRequest.ReadOnly =
    zio.aws.backupstorage.model.GetChunkRequest.wrap(buildAwsValue())
}
object GetChunkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupstorage.model.GetChunkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupstorage.model.GetChunkRequest =
      zio.aws.backupstorage.model.GetChunkRequest(storageJobId, chunkToken)
    def storageJobId: String
    def chunkToken: String
    def getStorageJobId: ZIO[Any, Nothing, String] = ZIO.succeed(storageJobId)
    def getChunkToken: ZIO[Any, Nothing, String] = ZIO.succeed(chunkToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupstorage.model.GetChunkRequest
  ) extends zio.aws.backupstorage.model.GetChunkRequest.ReadOnly {
    override val storageJobId: String = impl.storageJobId(): String
    override val chunkToken: String = impl.chunkToken(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupstorage.model.GetChunkRequest
  ): zio.aws.backupstorage.model.GetChunkRequest.ReadOnly = new Wrapper(impl)
}
