package zio.aws.backupstorage
import zio.aws.backupstorage.model.PutChunkResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.backupstorage.model.{
  ListObjectsRequest,
  StartObjectRequest,
  NotifyObjectCompleteRequest,
  ListChunksRequest,
  PutObjectRequest,
  PutChunkRequest,
  GetChunkRequest,
  GetObjectMetadataRequest,
  DeleteObjectRequest
}
import software.amazon.awssdk.services.backupstorage.BackupStorageAsyncClient
import zio.stream.ZStream
object BackupStorageMock extends Mock[BackupStorage] {
  object ListChunks
      extends Stream[
        ListChunksRequest,
        AwsError,
        zio.aws.backupstorage.model.Chunk.ReadOnly
      ]
  object ListChunksPaginated
      extends Effect[
        ListChunksRequest,
        AwsError,
        zio.aws.backupstorage.model.ListChunksResponse.ReadOnly
      ]
  object GetChunk
      extends Effect[GetChunkRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.backupstorage.model.GetChunkResponse.ReadOnly,
        Byte
      ]]
  object GetObjectMetadata
      extends Effect[GetObjectMetadataRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.backupstorage.model.GetObjectMetadataResponse.ReadOnly,
        Byte
      ]]
  object DeleteObject extends Effect[DeleteObjectRequest, AwsError, Unit]
  object PutChunk
      extends Effect[
        Tuple2[PutChunkRequest, ZStream[Any, AwsError, Byte]],
        AwsError,
        ReadOnly
      ]
  object ListObjects
      extends Stream[
        ListObjectsRequest,
        AwsError,
        zio.aws.backupstorage.model.BackupObject.ReadOnly
      ]
  object ListObjectsPaginated
      extends Effect[
        ListObjectsRequest,
        AwsError,
        zio.aws.backupstorage.model.ListObjectsResponse.ReadOnly
      ]
  object PutObject
      extends Effect[
        Tuple2[PutObjectRequest, ZStream[Any, AwsError, Byte]],
        AwsError,
        zio.aws.backupstorage.model.PutObjectResponse.ReadOnly
      ]
  object StartObject
      extends Effect[
        StartObjectRequest,
        AwsError,
        zio.aws.backupstorage.model.StartObjectResponse.ReadOnly
      ]
  object NotifyObjectComplete
      extends Effect[
        Tuple2[NotifyObjectCompleteRequest, ZStream[Any, AwsError, Byte]],
        AwsError,
        zio.aws.backupstorage.model.NotifyObjectCompleteResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, BackupStorage] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, BackupStorage] { rts =>
        zio.ZIO.succeed {
          new BackupStorage {
            val api: BackupStorageAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): BackupStorage = this
            def listChunks(request: ListChunksRequest): ZStream[
              Any,
              AwsError,
              zio.aws.backupstorage.model.Chunk.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListChunks, request)
                }
                .getOrThrowFiberFailure()
            }
            def listChunksPaginated(request: ListChunksRequest): IO[
              AwsError,
              zio.aws.backupstorage.model.ListChunksResponse.ReadOnly
            ] = proxy(ListChunksPaginated, request)
            def getChunk(
                request: GetChunkRequest
            ): IO[AwsError, StreamingOutputResult[
              Any,
              zio.aws.backupstorage.model.GetChunkResponse.ReadOnly,
              Byte
            ]] = proxy(GetChunk, request)
            def getObjectMetadata(
                request: GetObjectMetadataRequest
            ): IO[AwsError, StreamingOutputResult[
              Any,
              zio.aws.backupstorage.model.GetObjectMetadataResponse.ReadOnly,
              Byte
            ]] = proxy(GetObjectMetadata, request)
            def deleteObject(request: DeleteObjectRequest): IO[AwsError, Unit] =
              proxy(DeleteObject, request)
            def putChunk(
                request: PutChunkRequest,
                body: ZStream[Any, AwsError, Byte]
            ): IO[AwsError, ReadOnly] = proxy(PutChunk, request, body)
            def listObjects(request: ListObjectsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.backupstorage.model.BackupObject.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListObjects, request)
                }
                .getOrThrowFiberFailure()
            }
            def listObjectsPaginated(request: ListObjectsRequest): IO[
              AwsError,
              zio.aws.backupstorage.model.ListObjectsResponse.ReadOnly
            ] = proxy(ListObjectsPaginated, request)
            def putObject(
                request: PutObjectRequest,
                body: ZStream[Any, AwsError, Byte]
            ): IO[
              AwsError,
              zio.aws.backupstorage.model.PutObjectResponse.ReadOnly
            ] = proxy(PutObject, request, body)
            def startObject(request: StartObjectRequest): IO[
              AwsError,
              zio.aws.backupstorage.model.StartObjectResponse.ReadOnly
            ] = proxy(StartObject, request)
            def notifyObjectComplete(
                request: NotifyObjectCompleteRequest,
                body: ZStream[Any, AwsError, Byte]
            ): IO[
              AwsError,
              zio.aws.backupstorage.model.NotifyObjectCompleteResponse.ReadOnly
            ] = proxy(NotifyObjectComplete, request, body)
          }
        }
      }
    }
  }
}
