package zio.aws.backupstorage.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteObjectRequest(backupJobId: String, objectName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupstorage.model.DeleteObjectRequest = {
    import DeleteObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupstorage.model.DeleteObjectRequest
      .builder()
      .backupJobId(backupJobId: java.lang.String)
      .objectName(objectName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backupstorage.model.DeleteObjectRequest.ReadOnly =
    zio.aws.backupstorage.model.DeleteObjectRequest.wrap(buildAwsValue())
}
object DeleteObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupstorage.model.DeleteObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupstorage.model.DeleteObjectRequest =
      zio.aws.backupstorage.model.DeleteObjectRequest(backupJobId, objectName)
    def backupJobId: String
    def objectName: String
    def getBackupJobId: ZIO[Any, Nothing, String] = ZIO.succeed(backupJobId)
    def getObjectName: ZIO[Any, Nothing, String] = ZIO.succeed(objectName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupstorage.model.DeleteObjectRequest
  ) extends zio.aws.backupstorage.model.DeleteObjectRequest.ReadOnly {
    override val backupJobId: String = impl.backupJobId(): String
    override val objectName: String = impl.objectName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupstorage.model.DeleteObjectRequest
  ): zio.aws.backupstorage.model.DeleteObjectRequest.ReadOnly = new Wrapper(
    impl
  )
}
