package zio.aws.backupstorage.model
import zio.aws.backupstorage.model.primitives.MaxResults
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListChunksRequest(
    storageJobId: String,
    objectToken: String,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupstorage.model.ListChunksRequest = {
    import ListChunksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupstorage.model.ListChunksRequest
      .builder()
      .storageJobId(storageJobId: java.lang.String)
      .objectToken(objectToken: java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.backupstorage.model.ListChunksRequest.ReadOnly =
    zio.aws.backupstorage.model.ListChunksRequest.wrap(buildAwsValue())
}
object ListChunksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupstorage.model.ListChunksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupstorage.model.ListChunksRequest =
      zio.aws.backupstorage.model.ListChunksRequest(
        storageJobId,
        objectToken,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def storageJobId: String
    def objectToken: String
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[String]
    def getStorageJobId: ZIO[Any, Nothing, String] = ZIO.succeed(storageJobId)
    def getObjectToken: ZIO[Any, Nothing, String] = ZIO.succeed(objectToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupstorage.model.ListChunksRequest
  ) extends zio.aws.backupstorage.model.ListChunksRequest.ReadOnly {
    override val storageJobId: String = impl.storageJobId(): String
    override val objectToken: String = impl.objectToken(): String
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.backupstorage.model.primitives.MaxResults(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupstorage.model.ListChunksRequest
  ): zio.aws.backupstorage.model.ListChunksRequest.ReadOnly = new Wrapper(impl)
}
