package zio.aws.backupstorage.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartObjectRequest(
    backupJobId: String,
    objectName: String,
    throwOnDuplicate: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupstorage.model.StartObjectRequest = {
    import StartObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupstorage.model.StartObjectRequest
      .builder()
      .backupJobId(backupJobId: java.lang.String)
      .objectName(objectName: java.lang.String)
      .optionallyWith(throwOnDuplicate.map(value => value: java.lang.Boolean))(
        _.throwOnDuplicate
      )
      .build()
  }
  def asReadOnly: zio.aws.backupstorage.model.StartObjectRequest.ReadOnly =
    zio.aws.backupstorage.model.StartObjectRequest.wrap(buildAwsValue())
}
object StartObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupstorage.model.StartObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupstorage.model.StartObjectRequest =
      zio.aws.backupstorage.model.StartObjectRequest(
        backupJobId,
        objectName,
        throwOnDuplicate.map(value => value)
      )
    def backupJobId: String
    def objectName: String
    def throwOnDuplicate: Optional[Boolean]
    def getBackupJobId: ZIO[Any, Nothing, String] = ZIO.succeed(backupJobId)
    def getObjectName: ZIO[Any, Nothing, String] = ZIO.succeed(objectName)
    def getThrowOnDuplicate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("throwOnDuplicate", throwOnDuplicate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupstorage.model.StartObjectRequest
  ) extends zio.aws.backupstorage.model.StartObjectRequest.ReadOnly {
    override val backupJobId: String = impl.backupJobId(): String
    override val objectName: String = impl.objectName(): String
    override val throwOnDuplicate: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.throwOnDuplicate())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupstorage.model.StartObjectRequest
  ): zio.aws.backupstorage.model.StartObjectRequest.ReadOnly = new Wrapper(impl)
}
