package zio.aws.backupstorage.model
import scala.jdk.CollectionConverters._
sealed trait DataChecksumAlgorithm {
  def unwrap: software.amazon.awssdk.services.backupstorage.model.DataChecksumAlgorithm
}
object DataChecksumAlgorithm {
  def wrap(
      value: software.amazon.awssdk.services.backupstorage.model.DataChecksumAlgorithm
  ): zio.aws.backupstorage.model.DataChecksumAlgorithm = value match {
    case software.amazon.awssdk.services.backupstorage.model.DataChecksumAlgorithm.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.backupstorage.model.DataChecksumAlgorithm.SHA256 =>
      val r = SHA256
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.backupstorage.model.DataChecksumAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.backupstorage.model.DataChecksumAlgorithm =
      software.amazon.awssdk.services.backupstorage.model.DataChecksumAlgorithm.UNKNOWN_TO_SDK_VERSION
  }
  case object SHA256 extends zio.aws.backupstorage.model.DataChecksumAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.backupstorage.model.DataChecksumAlgorithm =
      software.amazon.awssdk.services.backupstorage.model.DataChecksumAlgorithm.SHA256
  }
}
