package zio.aws.backupstorage.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.backupstorage.model.primitives.OptionalLong
import scala.jdk.CollectionConverters._
final case class BackupObject(
    name: String,
    chunksCount: Optional[OptionalLong] = Optional.Absent,
    metadataString: Optional[String] = Optional.Absent,
    objectChecksum: String,
    objectChecksumAlgorithm: zio.aws.backupstorage.model.SummaryChecksumAlgorithm,
    objectToken: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupstorage.model.BackupObject = {
    import BackupObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupstorage.model.BackupObject
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(chunksCount.map(value => value: java.lang.Long))(
        _.chunksCount
      )
      .optionallyWith(metadataString.map(value => value: java.lang.String))(
        _.metadataString
      )
      .objectChecksum(objectChecksum: java.lang.String)
      .objectChecksumAlgorithm(objectChecksumAlgorithm.unwrap)
      .objectToken(objectToken: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backupstorage.model.BackupObject.ReadOnly =
    zio.aws.backupstorage.model.BackupObject.wrap(buildAwsValue())
}
object BackupObject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupstorage.model.BackupObject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupstorage.model.BackupObject =
      zio.aws.backupstorage.model.BackupObject(
        name,
        chunksCount.map(value => value),
        metadataString.map(value => value),
        objectChecksum,
        objectChecksumAlgorithm,
        objectToken
      )
    def name: String
    def chunksCount: Optional[OptionalLong]
    def metadataString: Optional[String]
    def objectChecksum: String
    def objectChecksumAlgorithm
        : zio.aws.backupstorage.model.SummaryChecksumAlgorithm
    def objectToken: String
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getChunksCount: ZIO[Any, AwsError, OptionalLong] =
      AwsError.unwrapOptionField("chunksCount", chunksCount)
    def getMetadataString: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("metadataString", metadataString)
    def getObjectChecksum: ZIO[Any, Nothing, String] =
      ZIO.succeed(objectChecksum)
    def getObjectChecksumAlgorithm: ZIO[
      Any,
      Nothing,
      zio.aws.backupstorage.model.SummaryChecksumAlgorithm
    ] = ZIO.succeed(objectChecksumAlgorithm)
    def getObjectToken: ZIO[Any, Nothing, String] = ZIO.succeed(objectToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupstorage.model.BackupObject
  ) extends zio.aws.backupstorage.model.BackupObject.ReadOnly {
    override val name: String = impl.name(): String
    override val chunksCount: Optional[OptionalLong] = zio.aws.core.internal
      .optionalFromNullable(impl.chunksCount())
      .map(value => value: OptionalLong)
    override val metadataString: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.metadataString())
      .map(value => value: String)
    override val objectChecksum: String = impl.objectChecksum(): String
    override val objectChecksumAlgorithm
        : zio.aws.backupstorage.model.SummaryChecksumAlgorithm =
      zio.aws.backupstorage.model.SummaryChecksumAlgorithm
        .wrap(impl.objectChecksumAlgorithm())
    override val objectToken: String = impl.objectToken(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupstorage.model.BackupObject
  ): zio.aws.backupstorage.model.BackupObject.ReadOnly = new Wrapper(impl)
}
