package zio.aws.backupstorage.model
import zio.aws.backupstorage.model.primitives.{Timestamp, MaxResults}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListObjectsRequest(
    storageJobId: String,
    startingObjectName: Optional[String] = Optional.Absent,
    startingObjectPrefix: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    createdBefore: Optional[Timestamp] = Optional.Absent,
    createdAfter: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupstorage.model.ListObjectsRequest = {
    import ListObjectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupstorage.model.ListObjectsRequest
      .builder()
      .storageJobId(storageJobId: java.lang.String)
      .optionallyWith(startingObjectName.map(value => value: java.lang.String))(
        _.startingObjectName
      )
      .optionallyWith(
        startingObjectPrefix.map(value => value: java.lang.String)
      )(_.startingObjectPrefix)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        createdBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdBefore)
      .optionallyWith(
        createdAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdAfter)
      .build()
  }
  def asReadOnly: zio.aws.backupstorage.model.ListObjectsRequest.ReadOnly =
    zio.aws.backupstorage.model.ListObjectsRequest.wrap(buildAwsValue())
}
object ListObjectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupstorage.model.ListObjectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupstorage.model.ListObjectsRequest =
      zio.aws.backupstorage.model.ListObjectsRequest(
        storageJobId,
        startingObjectName.map(value => value),
        startingObjectPrefix.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        createdBefore.map(value => value),
        createdAfter.map(value => value)
      )
    def storageJobId: String
    def startingObjectName: Optional[String]
    def startingObjectPrefix: Optional[String]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[String]
    def createdBefore: Optional[Timestamp]
    def createdAfter: Optional[Timestamp]
    def getStorageJobId: ZIO[Any, Nothing, String] = ZIO.succeed(storageJobId)
    def getStartingObjectName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startingObjectName", startingObjectName)
    def getStartingObjectPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startingObjectPrefix", startingObjectPrefix)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getCreatedBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdBefore", createdBefore)
    def getCreatedAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAfter", createdAfter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupstorage.model.ListObjectsRequest
  ) extends zio.aws.backupstorage.model.ListObjectsRequest.ReadOnly {
    override val storageJobId: String = impl.storageJobId(): String
    override val startingObjectName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.startingObjectName())
      .map(value => value: String)
    override val startingObjectPrefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.startingObjectPrefix())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.backupstorage.model.primitives.MaxResults(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val createdBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBefore())
      .map(value => zio.aws.backupstorage.model.primitives.Timestamp(value))
    override val createdAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAfter())
      .map(value => zio.aws.backupstorage.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupstorage.model.ListObjectsRequest
  ): zio.aws.backupstorage.model.ListObjectsRequest.ReadOnly = new Wrapper(impl)
}
