package zio.aws.backupstorage.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutChunkRequest(
    backupJobId: String,
    uploadId: String,
    chunkIndex: Long,
    length: Long,
    checksum: String,
    checksumAlgorithm: zio.aws.backupstorage.model.DataChecksumAlgorithm
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupstorage.model.PutChunkRequest = {
    import PutChunkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupstorage.model.PutChunkRequest
      .builder()
      .backupJobId(backupJobId: java.lang.String)
      .uploadId(uploadId: java.lang.String)
      .chunkIndex(chunkIndex: java.lang.Long)
      .length(length: java.lang.Long)
      .checksum(checksum: java.lang.String)
      .checksumAlgorithm(checksumAlgorithm.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.backupstorage.model.PutChunkRequest.ReadOnly =
    zio.aws.backupstorage.model.PutChunkRequest.wrap(buildAwsValue())
}
object PutChunkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupstorage.model.PutChunkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupstorage.model.PutChunkRequest =
      zio.aws.backupstorage.model.PutChunkRequest(
        backupJobId,
        uploadId,
        chunkIndex,
        length,
        checksum,
        checksumAlgorithm
      )
    def backupJobId: String
    def uploadId: String
    def chunkIndex: Long
    def length: Long
    def checksum: String
    def checksumAlgorithm: zio.aws.backupstorage.model.DataChecksumAlgorithm
    def getBackupJobId: ZIO[Any, Nothing, String] = ZIO.succeed(backupJobId)
    def getUploadId: ZIO[Any, Nothing, String] = ZIO.succeed(uploadId)
    def getChunkIndex: ZIO[Any, Nothing, Long] = ZIO.succeed(chunkIndex)
    def getLength: ZIO[Any, Nothing, Long] = ZIO.succeed(length)
    def getChecksum: ZIO[Any, Nothing, String] = ZIO.succeed(checksum)
    def getChecksumAlgorithm
        : ZIO[Any, Nothing, zio.aws.backupstorage.model.DataChecksumAlgorithm] =
      ZIO.succeed(checksumAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupstorage.model.PutChunkRequest
  ) extends zio.aws.backupstorage.model.PutChunkRequest.ReadOnly {
    override val backupJobId: String = impl.backupJobId(): String
    override val uploadId: String = impl.uploadId(): String
    override val chunkIndex: Long = impl.chunkIndex(): Long
    override val length: Long = impl.length(): Long
    override val checksum: String = impl.checksum(): String
    override val checksumAlgorithm
        : zio.aws.backupstorage.model.DataChecksumAlgorithm =
      zio.aws.backupstorage.model.DataChecksumAlgorithm
        .wrap(impl.checksumAlgorithm())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupstorage.model.PutChunkRequest
  ): zio.aws.backupstorage.model.PutChunkRequest.ReadOnly = new Wrapper(impl)
}
