package zio.aws.backupstorage.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Chunk(
    index: Long,
    length: Long,
    checksum: String,
    checksumAlgorithm: zio.aws.backupstorage.model.DataChecksumAlgorithm,
    chunkToken: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupstorage.model.Chunk = {
    import Chunk.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupstorage.model.Chunk
      .builder()
      .index(index: java.lang.Long)
      .length(length: java.lang.Long)
      .checksum(checksum: java.lang.String)
      .checksumAlgorithm(checksumAlgorithm.unwrap)
      .chunkToken(chunkToken: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backupstorage.model.Chunk.ReadOnly =
    zio.aws.backupstorage.model.Chunk.wrap(buildAwsValue())
}
object Chunk {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupstorage.model.Chunk
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupstorage.model.Chunk =
      zio.aws.backupstorage.model.Chunk(
        index,
        length,
        checksum,
        checksumAlgorithm,
        chunkToken
      )
    def index: Long
    def length: Long
    def checksum: String
    def checksumAlgorithm: zio.aws.backupstorage.model.DataChecksumAlgorithm
    def chunkToken: String
    def getIndex: ZIO[Any, Nothing, Long] = ZIO.succeed(index)
    def getLength: ZIO[Any, Nothing, Long] = ZIO.succeed(length)
    def getChecksum: ZIO[Any, Nothing, String] = ZIO.succeed(checksum)
    def getChecksumAlgorithm
        : ZIO[Any, Nothing, zio.aws.backupstorage.model.DataChecksumAlgorithm] =
      ZIO.succeed(checksumAlgorithm)
    def getChunkToken: ZIO[Any, Nothing, String] = ZIO.succeed(chunkToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupstorage.model.Chunk
  ) extends zio.aws.backupstorage.model.Chunk.ReadOnly {
    override val index: Long = impl.index(): Long
    override val length: Long = impl.length(): Long
    override val checksum: String = impl.checksum(): String
    override val checksumAlgorithm
        : zio.aws.backupstorage.model.DataChecksumAlgorithm =
      zio.aws.backupstorage.model.DataChecksumAlgorithm
        .wrap(impl.checksumAlgorithm())
    override val chunkToken: String = impl.chunkToken(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupstorage.model.Chunk
  ): zio.aws.backupstorage.model.Chunk.ReadOnly = new Wrapper(impl)
}
