package zio.aws.backupstorage.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetObjectMetadataRequest(
    storageJobId: String,
    objectToken: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupstorage.model.GetObjectMetadataRequest = {
    import GetObjectMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupstorage.model.GetObjectMetadataRequest
      .builder()
      .storageJobId(storageJobId: java.lang.String)
      .objectToken(objectToken: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.backupstorage.model.GetObjectMetadataRequest.ReadOnly =
    zio.aws.backupstorage.model.GetObjectMetadataRequest.wrap(buildAwsValue())
}
object GetObjectMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupstorage.model.GetObjectMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupstorage.model.GetObjectMetadataRequest =
      zio.aws.backupstorage.model
        .GetObjectMetadataRequest(storageJobId, objectToken)
    def storageJobId: String
    def objectToken: String
    def getStorageJobId: ZIO[Any, Nothing, String] = ZIO.succeed(storageJobId)
    def getObjectToken: ZIO[Any, Nothing, String] = ZIO.succeed(objectToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupstorage.model.GetObjectMetadataRequest
  ) extends zio.aws.backupstorage.model.GetObjectMetadataRequest.ReadOnly {
    override val storageJobId: String = impl.storageJobId(): String
    override val objectToken: String = impl.objectToken(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupstorage.model.GetObjectMetadataRequest
  ): zio.aws.backupstorage.model.GetObjectMetadataRequest.ReadOnly =
    new Wrapper(impl)
}
