package zio.aws.backupstorage.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutObjectResponse(
    inlineChunkChecksum: String,
    inlineChunkChecksumAlgorithm: zio.aws.backupstorage.model.DataChecksumAlgorithm,
    objectChecksum: String,
    objectChecksumAlgorithm: zio.aws.backupstorage.model.SummaryChecksumAlgorithm
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupstorage.model.PutObjectResponse = {
    import PutObjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupstorage.model.PutObjectResponse
      .builder()
      .inlineChunkChecksum(inlineChunkChecksum: java.lang.String)
      .inlineChunkChecksumAlgorithm(inlineChunkChecksumAlgorithm.unwrap)
      .objectChecksum(objectChecksum: java.lang.String)
      .objectChecksumAlgorithm(objectChecksumAlgorithm.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.backupstorage.model.PutObjectResponse.ReadOnly =
    zio.aws.backupstorage.model.PutObjectResponse.wrap(buildAwsValue())
}
object PutObjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupstorage.model.PutObjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupstorage.model.PutObjectResponse =
      zio.aws.backupstorage.model.PutObjectResponse(
        inlineChunkChecksum,
        inlineChunkChecksumAlgorithm,
        objectChecksum,
        objectChecksumAlgorithm
      )
    def inlineChunkChecksum: String
    def inlineChunkChecksumAlgorithm
        : zio.aws.backupstorage.model.DataChecksumAlgorithm
    def objectChecksum: String
    def objectChecksumAlgorithm
        : zio.aws.backupstorage.model.SummaryChecksumAlgorithm
    def getInlineChunkChecksum: ZIO[Any, Nothing, String] =
      ZIO.succeed(inlineChunkChecksum)
    def getInlineChunkChecksumAlgorithm
        : ZIO[Any, Nothing, zio.aws.backupstorage.model.DataChecksumAlgorithm] =
      ZIO.succeed(inlineChunkChecksumAlgorithm)
    def getObjectChecksum: ZIO[Any, Nothing, String] =
      ZIO.succeed(objectChecksum)
    def getObjectChecksumAlgorithm: ZIO[
      Any,
      Nothing,
      zio.aws.backupstorage.model.SummaryChecksumAlgorithm
    ] = ZIO.succeed(objectChecksumAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupstorage.model.PutObjectResponse
  ) extends zio.aws.backupstorage.model.PutObjectResponse.ReadOnly {
    override val inlineChunkChecksum: String =
      impl.inlineChunkChecksum(): String
    override val inlineChunkChecksumAlgorithm
        : zio.aws.backupstorage.model.DataChecksumAlgorithm =
      zio.aws.backupstorage.model.DataChecksumAlgorithm
        .wrap(impl.inlineChunkChecksumAlgorithm())
    override val objectChecksum: String = impl.objectChecksum(): String
    override val objectChecksumAlgorithm
        : zio.aws.backupstorage.model.SummaryChecksumAlgorithm =
      zio.aws.backupstorage.model.SummaryChecksumAlgorithm
        .wrap(impl.objectChecksumAlgorithm())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupstorage.model.PutObjectResponse
  ): zio.aws.backupstorage.model.PutObjectResponse.ReadOnly = new Wrapper(impl)
}
