package zio.aws.backupstorage.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.backupstorage.model.primitives.MetadataString
import scala.jdk.CollectionConverters._
final case class NotifyObjectCompleteRequest(
    backupJobId: String,
    uploadId: String,
    objectChecksum: String,
    objectChecksumAlgorithm: zio.aws.backupstorage.model.SummaryChecksumAlgorithm,
    metadataString: Optional[MetadataString] = Optional.Absent,
    metadataBlobLength: Optional[Long] = Optional.Absent,
    metadataBlobChecksum: Optional[String] = Optional.Absent,
    metadataBlobChecksumAlgorithm: Optional[
      zio.aws.backupstorage.model.DataChecksumAlgorithm
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupstorage.model.NotifyObjectCompleteRequest = {
    import NotifyObjectCompleteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupstorage.model.NotifyObjectCompleteRequest
      .builder()
      .backupJobId(backupJobId: java.lang.String)
      .uploadId(uploadId: java.lang.String)
      .objectChecksum(objectChecksum: java.lang.String)
      .objectChecksumAlgorithm(objectChecksumAlgorithm.unwrap)
      .optionallyWith(
        metadataString.map(value =>
          MetadataString.unwrap(value): java.lang.String
        )
      )(_.metadataString)
      .optionallyWith(metadataBlobLength.map(value => value: java.lang.Long))(
        _.metadataBlobLength
      )
      .optionallyWith(
        metadataBlobChecksum.map(value => value: java.lang.String)
      )(_.metadataBlobChecksum)
      .optionallyWith(metadataBlobChecksumAlgorithm.map(value => value.unwrap))(
        _.metadataBlobChecksumAlgorithm
      )
      .build()
  }
  def asReadOnly
      : zio.aws.backupstorage.model.NotifyObjectCompleteRequest.ReadOnly =
    zio.aws.backupstorage.model.NotifyObjectCompleteRequest
      .wrap(buildAwsValue())
}
object NotifyObjectCompleteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupstorage.model.NotifyObjectCompleteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupstorage.model.NotifyObjectCompleteRequest =
      zio.aws.backupstorage.model.NotifyObjectCompleteRequest(
        backupJobId,
        uploadId,
        objectChecksum,
        objectChecksumAlgorithm,
        metadataString.map(value => value),
        metadataBlobLength.map(value => value),
        metadataBlobChecksum.map(value => value),
        metadataBlobChecksumAlgorithm.map(value => value)
      )
    def backupJobId: String
    def uploadId: String
    def objectChecksum: String
    def objectChecksumAlgorithm
        : zio.aws.backupstorage.model.SummaryChecksumAlgorithm
    def metadataString: Optional[MetadataString]
    def metadataBlobLength: Optional[Long]
    def metadataBlobChecksum: Optional[String]
    def metadataBlobChecksumAlgorithm
        : Optional[zio.aws.backupstorage.model.DataChecksumAlgorithm]
    def getBackupJobId: ZIO[Any, Nothing, String] = ZIO.succeed(backupJobId)
    def getUploadId: ZIO[Any, Nothing, String] = ZIO.succeed(uploadId)
    def getObjectChecksum: ZIO[Any, Nothing, String] =
      ZIO.succeed(objectChecksum)
    def getObjectChecksumAlgorithm: ZIO[
      Any,
      Nothing,
      zio.aws.backupstorage.model.SummaryChecksumAlgorithm
    ] = ZIO.succeed(objectChecksumAlgorithm)
    def getMetadataString: ZIO[Any, AwsError, MetadataString] =
      AwsError.unwrapOptionField("metadataString", metadataString)
    def getMetadataBlobLength: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("metadataBlobLength", metadataBlobLength)
    def getMetadataBlobChecksum: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("metadataBlobChecksum", metadataBlobChecksum)
    def getMetadataBlobChecksumAlgorithm: ZIO[
      Any,
      AwsError,
      zio.aws.backupstorage.model.DataChecksumAlgorithm
    ] = AwsError.unwrapOptionField(
      "metadataBlobChecksumAlgorithm",
      metadataBlobChecksumAlgorithm
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupstorage.model.NotifyObjectCompleteRequest
  ) extends zio.aws.backupstorage.model.NotifyObjectCompleteRequest.ReadOnly {
    override val backupJobId: String = impl.backupJobId(): String
    override val uploadId: String = impl.uploadId(): String
    override val objectChecksum: String = impl.objectChecksum(): String
    override val objectChecksumAlgorithm
        : zio.aws.backupstorage.model.SummaryChecksumAlgorithm =
      zio.aws.backupstorage.model.SummaryChecksumAlgorithm
        .wrap(impl.objectChecksumAlgorithm())
    override val metadataString: Optional[MetadataString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadataString())
        .map(value =>
          zio.aws.backupstorage.model.primitives.MetadataString(value)
        )
    override val metadataBlobLength: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.metadataBlobLength())
      .map(value => value: Long)
    override val metadataBlobChecksum: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.metadataBlobChecksum())
      .map(value => value: String)
    override val metadataBlobChecksumAlgorithm
        : Optional[zio.aws.backupstorage.model.DataChecksumAlgorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadataBlobChecksumAlgorithm())
        .map(value =>
          zio.aws.backupstorage.model.DataChecksumAlgorithm.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupstorage.model.NotifyObjectCompleteRequest
  ): zio.aws.backupstorage.model.NotifyObjectCompleteRequest.ReadOnly =
    new Wrapper(impl)
}
