package zio.aws.backupstorage.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListChunksResponse(
    chunkList: Iterable[zio.aws.backupstorage.model.Chunk],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupstorage.model.ListChunksResponse = {
    import ListChunksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupstorage.model.ListChunksResponse
      .builder()
      .chunkList(chunkList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.backupstorage.model.ListChunksResponse.ReadOnly =
    zio.aws.backupstorage.model.ListChunksResponse.wrap(buildAwsValue())
}
object ListChunksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupstorage.model.ListChunksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupstorage.model.ListChunksResponse =
      zio.aws.backupstorage.model.ListChunksResponse(
        chunkList.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def chunkList: List[zio.aws.backupstorage.model.Chunk.ReadOnly]
    def nextToken: Optional[String]
    def getChunkList
        : ZIO[Any, Nothing, List[zio.aws.backupstorage.model.Chunk.ReadOnly]] =
      ZIO.succeed(chunkList)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupstorage.model.ListChunksResponse
  ) extends zio.aws.backupstorage.model.ListChunksResponse.ReadOnly {
    override val chunkList: List[zio.aws.backupstorage.model.Chunk.ReadOnly] =
      impl
        .chunkList()
        .asScala
        .map { item =>
          zio.aws.backupstorage.model.Chunk.wrap(item)
        }
        .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupstorage.model.ListChunksResponse
  ): zio.aws.backupstorage.model.ListChunksResponse.ReadOnly = new Wrapper(impl)
}
