package zio.aws.backupstorage.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetObjectMetadataResponse(
    metadataString: Optional[String] = Optional.Absent,
    metadataBlobLength: Optional[Long] = Optional.Absent,
    metadataBlobChecksum: Optional[String] = Optional.Absent,
    metadataBlobChecksumAlgorithm: Optional[
      zio.aws.backupstorage.model.DataChecksumAlgorithm
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupstorage.model.GetObjectMetadataResponse = {
    import GetObjectMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupstorage.model.GetObjectMetadataResponse
      .builder()
      .optionallyWith(metadataString.map(value => value: java.lang.String))(
        _.metadataString
      )
      .optionallyWith(metadataBlobLength.map(value => value: java.lang.Long))(
        _.metadataBlobLength
      )
      .optionallyWith(
        metadataBlobChecksum.map(value => value: java.lang.String)
      )(_.metadataBlobChecksum)
      .optionallyWith(metadataBlobChecksumAlgorithm.map(value => value.unwrap))(
        _.metadataBlobChecksumAlgorithm
      )
      .build()
  }
  def asReadOnly
      : zio.aws.backupstorage.model.GetObjectMetadataResponse.ReadOnly =
    zio.aws.backupstorage.model.GetObjectMetadataResponse.wrap(buildAwsValue())
}
object GetObjectMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupstorage.model.GetObjectMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupstorage.model.GetObjectMetadataResponse =
      zio.aws.backupstorage.model.GetObjectMetadataResponse(
        metadataString.map(value => value),
        metadataBlobLength.map(value => value),
        metadataBlobChecksum.map(value => value),
        metadataBlobChecksumAlgorithm.map(value => value)
      )
    def metadataString: Optional[String]
    def metadataBlobLength: Optional[Long]
    def metadataBlobChecksum: Optional[String]
    def metadataBlobChecksumAlgorithm
        : Optional[zio.aws.backupstorage.model.DataChecksumAlgorithm]
    def getMetadataString: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("metadataString", metadataString)
    def getMetadataBlobLength: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("metadataBlobLength", metadataBlobLength)
    def getMetadataBlobChecksum: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("metadataBlobChecksum", metadataBlobChecksum)
    def getMetadataBlobChecksumAlgorithm: ZIO[
      Any,
      AwsError,
      zio.aws.backupstorage.model.DataChecksumAlgorithm
    ] = AwsError.unwrapOptionField(
      "metadataBlobChecksumAlgorithm",
      metadataBlobChecksumAlgorithm
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupstorage.model.GetObjectMetadataResponse
  ) extends zio.aws.backupstorage.model.GetObjectMetadataResponse.ReadOnly {
    override val metadataString: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.metadataString())
      .map(value => value: String)
    override val metadataBlobLength: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.metadataBlobLength())
      .map(value => value: Long)
    override val metadataBlobChecksum: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.metadataBlobChecksum())
      .map(value => value: String)
    override val metadataBlobChecksumAlgorithm
        : Optional[zio.aws.backupstorage.model.DataChecksumAlgorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadataBlobChecksumAlgorithm())
        .map(value =>
          zio.aws.backupstorage.model.DataChecksumAlgorithm.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupstorage.model.GetObjectMetadataResponse
  ): zio.aws.backupstorage.model.GetObjectMetadataResponse.ReadOnly =
    new Wrapper(impl)
}
